/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.types;

import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.TimestampNTZType;

public class TypeWideningChecker {
    private TypeWideningChecker() {
    }

    public static boolean isWideningSupported(DataType dataType, DataType dataType2) {
        if (TypeWideningChecker.isIcebergV2Compatible(dataType, dataType2)) {
            return true;
        }
        if (TypeWideningChecker.isIntegerToDoubleWidening(dataType, dataType2)) {
            return true;
        }
        if (TypeWideningChecker.isDateToTimestampNtzWidening(dataType, dataType2)) {
            return true;
        }
        return TypeWideningChecker.isDecimalWidening(dataType, dataType2);
    }

    public static boolean isIcebergV2Compatible(DataType dataType, DataType dataType2) {
        if (dataType.equals(dataType2)) {
            return true;
        }
        if (TypeWideningChecker.isIntegerWidening(dataType, dataType2)) {
            return true;
        }
        if (TypeWideningChecker.isFloatToDoubleWidening(dataType, dataType2)) {
            return true;
        }
        if (dataType instanceof DecimalType && dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            DecimalType decimalType2 = (DecimalType)dataType2;
            if (decimalType2.getScale() != decimalType.getScale()) {
                return false;
            }
            return decimalType2.getPrecision() >= decimalType.getPrecision();
        }
        return false;
    }

    private static boolean isIntegerWidening(DataType dataType, DataType dataType2) {
        if (dataType instanceof ByteType) {
            return dataType2 instanceof ShortType || dataType2 instanceof IntegerType || dataType2 instanceof LongType;
        }
        if (dataType instanceof ShortType) {
            return dataType2 instanceof IntegerType || dataType2 instanceof LongType;
        }
        if (dataType instanceof IntegerType) {
            return dataType2 instanceof LongType;
        }
        return false;
    }

    private static boolean isFloatToDoubleWidening(DataType dataType, DataType dataType2) {
        return dataType instanceof FloatType && dataType2 instanceof DoubleType;
    }

    private static boolean isIntegerToDoubleWidening(DataType dataType, DataType dataType2) {
        return (dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType) && dataType2 instanceof DoubleType;
    }

    private static boolean isDateToTimestampNtzWidening(DataType dataType, DataType dataType2) {
        return dataType instanceof DateType && dataType2 instanceof TimestampNTZType;
    }

    private static boolean isDecimalWidening(DataType dataType, DataType dataType2) {
        if (dataType instanceof DecimalType && dataType2 instanceof DecimalType) {
            int n;
            DecimalType decimalType = (DecimalType)dataType;
            DecimalType decimalType2 = (DecimalType)dataType2;
            int n2 = decimalType2.getPrecision() - decimalType.getPrecision();
            return n2 >= (n = decimalType2.getScale() - decimalType.getScale()) && n >= 0;
        }
        if ((dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType) && dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            int n = 10;
            return decimalType.getPrecision() >= n && decimalType.getPrecision() - n >= decimalType.getScale() && decimalType.getScale() >= 0;
        }
        if (dataType instanceof LongType && dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            int n = 20;
            return decimalType.getPrecision() >= n && decimalType.getPrecision() - n >= decimalType.getScale() && decimalType.getScale() >= 0;
        }
        return false;
    }
}

