/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.snapshot;

import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.Lazy;
import io.delta.kernel.internal.lang.ListUtils;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.utils.FileStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSegment {
    private static final Logger logger = LoggerFactory.getLogger(LogSegment.class);
    private final Path logPath;
    private final long version;
    private final List<FileStatus> deltas;
    private final List<FileStatus> compactions;
    private final List<FileStatus> checkpoints;
    private final Optional<Long> checkpointVersionOpt;
    private final Optional<FileStatus> lastSeenChecksum;
    private final long lastCommitTimestamp;
    private final Lazy<List<FileStatus>> allFiles;
    private final Lazy<List<FileStatus>> allFilesReversed;
    private final Lazy<List<FileStatus>> compactionsReversed;
    private final Lazy<List<FileStatus>> allFilesWithCompactionsReversed;

    public static LogSegment empty(Path path) {
        return new LogSegment(path, -1L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Optional.empty(), -1L);
    }

    public LogSegment(Path path, long l3, List<FileStatus> list, List<FileStatus> list2, List<FileStatus> list3, Optional<FileStatus> optional, long l4) {
        Objects.requireNonNull(path, "logPath is null");
        Objects.requireNonNull(list, "deltas is null");
        Objects.requireNonNull(list2, "compactions is null");
        Objects.requireNonNull(list3, "checkpoints is null");
        Objects.requireNonNull(optional, "lastSeenChecksum null");
        Preconditions.checkArgument(list.stream().allMatch(fileStatus -> FileNames.isCommitFile(fileStatus.getPath())), "deltas must all be actual delta (commit) files");
        Preconditions.checkArgument(list2.stream().allMatch(fileStatus -> FileNames.isLogCompactionFile(fileStatus.getPath())), "compactions must all be actual log compaction files");
        Preconditions.checkArgument(list3.stream().allMatch(fileStatus -> FileNames.isCheckpointFile(fileStatus.getPath())), "checkpoints must all be actual checkpoint files");
        Preconditions.checkArgument(list2.stream().allMatch(fileStatus -> {
            Tuple2<Long, Long> tuple2 = FileNames.logCompactionVersions(fileStatus.getPath());
            return (Long)tuple2._1 < (Long)tuple2._2;
        }), "compactions must have start version less than end version");
        this.checkpointVersionOpt = list3.isEmpty() ? Optional.empty() : Optional.of(FileNames.checkpointVersion(new Path(list3.get(0).getPath())));
        Preconditions.checkArgument(list3.stream().map(fileStatus -> FileNames.checkpointVersion(new Path(fileStatus.getPath()))).allMatch(l -> this.checkpointVersionOpt.get().equals(l)), "All checkpoint files must have the same version");
        optional.ifPresent(fileStatus -> {
            long l3 = FileNames.checksumVersion(new Path(fileStatus.getPath()));
            Preconditions.checkArgument(l3 <= l3, "checksum file's version should be less than or equal to logSegment's version");
            this.checkpointVersionOpt.ifPresent(l2 -> Preconditions.checkArgument(l3 >= l2, "checksum file's version %s should be greater than or equal to checkpoint version %s", l3, l2));
        });
        if (l3 != -1L) {
            Preconditions.checkArgument(!list.isEmpty() || !list3.isEmpty(), "No files to read");
            if (!list.isEmpty()) {
                List list4 = list.stream().map(fileStatus -> FileNames.deltaVersion(new Path(fileStatus.getPath()))).collect(Collectors.toList());
                this.checkpointVersionOpt.ifPresent(l -> Preconditions.checkArgument((Long)list4.get(0) == l + 1L, "First delta file version must equal checkpointVersion + 1"));
                Preconditions.checkArgument((Long)ListUtils.getLast(list4) == l3, "Last delta file version must equal the version of this LogSegment");
                for (int i = 1; i < list4.size(); ++i) {
                    if ((Long)list4.get(i) == (Long)list4.get(i - 1) + 1L) continue;
                    throw new IllegalArgumentException(String.format("Delta versions must be contiguous: %s", list4));
                }
                Preconditions.checkArgument(list2.stream().allMatch(fileStatus -> {
                    Tuple2<Long, Long> tuple2 = FileNames.logCompactionVersions(fileStatus.getPath());
                    boolean bl = this.checkpointVersionOpt.map(l -> (Long)tuple2._1 > l).orElse(true);
                    return bl && (Long)tuple2._2 <= l3;
                }), "compactions must have start version > checkpointVersion AND end version <= version");
            } else {
                this.checkpointVersionOpt.ifPresent(l2 -> Preconditions.checkArgument(l2 == l3, "If there are no deltas, then checkpointVersion must equal the version of this LogSegment"));
            }
        } else {
            Preconditions.checkArgument(list.isEmpty() && list3.isEmpty(), "Version -1 should have no files");
        }
        this.logPath = path;
        this.version = l3;
        this.deltas = list;
        this.compactions = list2;
        this.checkpoints = list3;
        this.lastSeenChecksum = optional;
        this.lastCommitTimestamp = l4;
        this.allFiles = new Lazy<List>(() -> Stream.concat(list3.stream(), list.stream()).collect(Collectors.toList()));
        this.allFilesReversed = new Lazy<List>(() -> this.allFiles.get().stream().sorted(Comparator.comparing(fileStatus -> new Path(fileStatus.getPath()).getName()).reversed()).collect(Collectors.toList()));
        this.compactionsReversed = new Lazy<List>(() -> list2.stream().sorted(Comparator.comparing(fileStatus -> (Long)FileNames.logCompactionVersions((String)fileStatus.getPath())._2).reversed()).collect(Collectors.toList()));
        this.allFilesWithCompactionsReversed = new Lazy<List>(() -> {
            if (list2.isEmpty()) {
                return this.allFilesReversed.get();
            }
            LogCompactionResolver logCompactionResolver = new LogCompactionResolver(this.allFilesReversed.get(), this.compactionsReversed.get());
            return logCompactionResolver.resolveFiles();
        });
        logger.debug("Created LogSegment: {}", (Object)this);
    }

    public boolean isComplete() {
        return this.version >= 0L && (!this.checkpoints.isEmpty() || (long)this.deltas.size() == this.version + 1L);
    }

    public Path getLogPath() {
        return this.logPath;
    }

    public long getVersion() {
        return this.version;
    }

    public List<FileStatus> getDeltas() {
        return this.deltas;
    }

    public List<FileStatus> getCompactions() {
        return this.compactions;
    }

    public List<FileStatus> getCheckpoints() {
        return this.checkpoints;
    }

    public Optional<Long> getCheckpointVersionOpt() {
        return this.checkpointVersionOpt;
    }

    public Optional<FileStatus> getLastSeenChecksum() {
        return this.lastSeenChecksum;
    }

    public long getLastCommitTimestamp() {
        return this.lastCommitTimestamp;
    }

    public List<FileStatus> allLogFilesUnsorted() {
        return this.allFiles.get();
    }

    public List<FileStatus> allLogFilesReversed() {
        return this.allFilesReversed.get();
    }

    public List<FileStatus> allFilesWithCompactionsReversed() {
        return this.allFilesWithCompactionsReversed.get();
    }

    public String toString() {
        return String.format("LogSegment {\n  logPath='%s',\n  version=%d,\n  deltas=[%s\n  ],\n  checkpoints=[%s\n  ],\n  lastSeenChecksum=%s,\n  checkpointVersion=%s,\n  lastCommitTimestamp=%d\n}", this.logPath, this.version, this.formatList(this.deltas), this.formatList(this.checkpoints), this.lastSeenChecksum.map(FileStatus::toString).orElse("None"), this.checkpointVersionOpt.map(String::valueOf).orElse("None"), this.lastCommitTimestamp);
    }

    private String formatList(List<FileStatus> list) {
        if (list.isEmpty()) {
            return "";
        }
        return "\n    " + list.stream().map(FileStatus::toString).collect(Collectors.joining(",\n    "));
    }

    private class LogCompactionResolver {
        int currentCompactionPos = 0;
        long currentCompactionHi = -1L;
        long currentCompactionLo = -1L;
        final List<FileStatus> compactionsReversed;
        final Iterator<FileStatus> deltaIt;

        LogCompactionResolver(List<FileStatus> list, List<FileStatus> list2) {
            this.deltaIt = list.iterator();
            this.compactionsReversed = list2;
        }

        List<FileStatus> resolveFiles() {
            ArrayList<FileStatus> arrayList = new ArrayList<FileStatus>();
            this.setHiLo();
            while (this.deltaIt.hasNext()) {
                FileStatus fileStatus = this.deltaIt.next();
                long l = FileNames.deltaVersion(fileStatus.getPath());
                if (l == this.currentCompactionLo) {
                    arrayList.add(this.compactionsReversed.get(this.currentCompactionPos));
                    this.advanceCompactionPos();
                    this.setHiLo();
                    continue;
                }
                if (l <= this.currentCompactionHi) continue;
                arrayList.add(fileStatus);
            }
            return arrayList;
        }

        private void advanceCompactionPos() {
            ++this.currentCompactionPos;
            while (this.currentCompactionPos < this.compactionsReversed.size()) {
                Tuple2<Long, Long> tuple2 = FileNames.logCompactionVersions(this.compactionsReversed.get(this.currentCompactionPos).getPath());
                if ((Long)tuple2._2 < this.currentCompactionLo) break;
                ++this.currentCompactionPos;
            }
        }

        private void setHiLo() {
            if (this.currentCompactionPos < this.compactionsReversed.size()) {
                Tuple2<Long, Long> tuple2 = FileNames.logCompactionVersions(this.compactionsReversed.get(this.currentCompactionPos).getPath());
                this.currentCompactionLo = (Long)tuple2._1;
                this.currentCompactionHi = (Long)tuple2._2;
            } else {
                this.currentCompactionHi = -1L;
                this.currentCompactionLo = -1L;
            }
        }
    }
}

