/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.icebergcompat;

import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.icebergcompat.IcebergCompatMetadataValidatorAndUpdater;
import io.delta.kernel.internal.icebergcompat.IcebergCompatV2MetadataValidatorAndUpdater;
import io.delta.kernel.internal.tablefeatures.TableFeature;
import io.delta.kernel.internal.tablefeatures.TableFeatures;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.SchemaUtils;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StructField;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IcebergWriterCompatV1MetadataValidatorAndUpdater
extends IcebergCompatMetadataValidatorAndUpdater {
    private static final IcebergWriterCompatV1MetadataValidatorAndUpdater INSTANCE = new IcebergWriterCompatV1MetadataValidatorAndUpdater();
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatRequiredTablePropertyEnforcer CM_ID_MODE_ENABLED = new IcebergCompatMetadataValidatorAndUpdater.IcebergCompatRequiredTablePropertyEnforcer<ColumnMapping.ColumnMappingMode>(TableConfig.COLUMN_MAPPING_MODE, columnMappingMode -> ColumnMapping.ColumnMappingMode.ID == columnMappingMode, ColumnMapping.ColumnMappingMode.ID.value, icebergCompatInputContext -> ColumnMapping.updateColumnMappingMetadataIfNeeded(icebergCompatInputContext.newMetadata, icebergCompatInputContext.isCreatingNewTable));
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatRequiredTablePropertyEnforcer ICEBERG_COMPAT_V2_ENABLED = new IcebergCompatMetadataValidatorAndUpdater.IcebergCompatRequiredTablePropertyEnforcer<Boolean>(TableConfig.ICEBERG_COMPAT_V2_ENABLED, bl -> bl, "true", icebergCompatInputContext -> IcebergCompatV2MetadataValidatorAndUpdater.validateAndUpdateIcebergCompatV2Metadata(icebergCompatInputContext.isCreatingNewTable, icebergCompatInputContext.newMetadata, icebergCompatInputContext.newProtocol));
    private static Set<TableFeature> ALLOWED_TABLE_FEATURES = Stream.of(TableFeatures.INVARIANTS_W_FEATURE, TableFeatures.CHANGE_DATA_FEED_W_FEATURE, TableFeatures.CONSTRAINTS_W_FEATURE, TableFeatures.IDENTITY_COLUMNS_W_FEATURE, TableFeatures.GENERATED_COLUMNS_W_FEATURE, TableFeatures.APPEND_ONLY_W_FEATURE, TableFeatures.COLUMN_MAPPING_RW_FEATURE, TableFeatures.ICEBERG_COMPAT_V2_W_FEATURE, TableFeatures.ICEBERG_WRITER_COMPAT_V1, TableFeatures.DOMAIN_METADATA_W_FEATURE, TableFeatures.VACUUM_PROTOCOL_CHECK_RW_FEATURE, TableFeatures.CHECKPOINT_V2_RW_FEATURE, TableFeatures.IN_COMMIT_TIMESTAMP_W_FEATURE, TableFeatures.CLUSTERING_W_FEATURE, TableFeatures.TIMESTAMP_NTZ_RW_FEATURE, TableFeatures.TYPE_WIDENING_RW_FEATURE, TableFeatures.TYPE_WIDENING_RW_PREVIEW_FEATURE).collect(Collectors.toSet());
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatCheck UNSUPPORTED_FEATURES_CHECK = icebergCompatInputContext -> {
        if (!ALLOWED_TABLE_FEATURES.containsAll(icebergCompatInputContext.newProtocol.getImplicitlyAndExplicitlySupportedFeatures())) {
            Set<TableFeature> set = icebergCompatInputContext.newProtocol.getImplicitlyAndExplicitlySupportedFeatures();
            set.removeAll(ALLOWED_TABLE_FEATURES);
            throw DeltaErrors.icebergCompatIncompatibleTableFeatures(INSTANCE.compatFeatureName(), set);
        }
    };
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatCheck UNSUPPORTED_TYPES_CHECK = icebergCompatInputContext -> {
        List<Tuple2<List<String>, StructField>> list = SchemaUtils.filterRecursively(icebergCompatInputContext.newMetadata.getSchema(), true, false, structField -> {
            DataType dataType = structField.getDataType();
            return dataType instanceof ByteType || dataType instanceof ShortType;
        });
        if (!list.isEmpty()) {
            throw DeltaErrors.icebergCompatUnsupportedTypeColumns(INSTANCE.compatFeatureName(), list.stream().map(tuple2 -> ((StructField)tuple2._2).getDataType()).collect(Collectors.toList()));
        }
    };
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatCheck PHYSICAL_NAMES_MATCH_FIELD_IDS_CHECK = icebergCompatInputContext -> {
        List<Tuple2<List<String>, StructField>> list = SchemaUtils.filterRecursively(icebergCompatInputContext.newMetadata.getSchema(), true, false, structField -> {
            String string = ColumnMapping.getPhysicalName(structField);
            long l = ColumnMapping.getColumnId(structField);
            return !string.equals(String.format("col-%s", l));
        });
        if (!list.isEmpty()) {
            List<String> list2 = list.stream().map(tuple2 -> String.format("%s(physicalName='%s', columnId=%s)", SchemaUtils.concatWithDot((List)tuple2._1), ColumnMapping.getPhysicalName((StructField)tuple2._2), ColumnMapping.getColumnId((StructField)tuple2._2))).collect(Collectors.toList());
            throw DeltaErrors.icebergWriterCompatInvalidPhysicalName(list2);
        }
    };
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatCheck INVARIANTS_INACTIVE_CHECK = icebergCompatInputContext -> {
        if (TableFeatures.hasInvariants(icebergCompatInputContext.newMetadata.getSchema())) {
            throw DeltaErrors.icebergCompatIncompatibleTableFeatures(INSTANCE.compatFeatureName(), Collections.singleton(TableFeatures.INVARIANTS_W_FEATURE));
        }
    };
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatCheck CHANGE_DATA_FEED_INACTIVE_CHECK = icebergCompatInputContext -> {
        if (TableConfig.CHANGE_DATA_FEED_ENABLED.fromMetadata(icebergCompatInputContext.newMetadata).booleanValue()) {
            throw DeltaErrors.icebergCompatIncompatibleTableFeatures(INSTANCE.compatFeatureName(), Collections.singleton(TableFeatures.CHANGE_DATA_FEED_W_FEATURE));
        }
    };
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatCheck CHECK_CONSTRAINTS_INACTIVE_CHECK = icebergCompatInputContext -> {
        if (TableFeatures.hasCheckConstraints(icebergCompatInputContext.newMetadata)) {
            throw DeltaErrors.icebergCompatIncompatibleTableFeatures(INSTANCE.compatFeatureName(), Collections.singleton(TableFeatures.CONSTRAINTS_W_FEATURE));
        }
    };
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatCheck IDENTITY_COLUMNS_INACTIVE_CHECK = icebergCompatInputContext -> {
        if (TableFeatures.hasIdentityColumns(icebergCompatInputContext.newMetadata)) {
            throw DeltaErrors.icebergCompatIncompatibleTableFeatures(INSTANCE.compatFeatureName(), Collections.singleton(TableFeatures.IDENTITY_COLUMNS_W_FEATURE));
        }
    };
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatCheck GENERATED_COLUMNS_INACTIVE_CHECK = icebergCompatInputContext -> {
        if (TableFeatures.hasGeneratedColumns(icebergCompatInputContext.newMetadata)) {
            throw DeltaErrors.icebergCompatIncompatibleTableFeatures(INSTANCE.compatFeatureName(), Collections.singleton(TableFeatures.GENERATED_COLUMNS_W_FEATURE));
        }
    };

    public static void validateIcebergWriterCompatV1Change(Map<String, String> map, Map<String, String> map2, boolean bl) {
        if (!bl) {
            boolean bl2 = TableConfig.ICEBERG_WRITER_COMPAT_V1_ENABLED.fromMetadata(map);
            boolean bl3 = TableConfig.ICEBERG_WRITER_COMPAT_V1_ENABLED.fromMetadata(map2);
            if (!bl2 && bl3) {
                throw DeltaErrors.enablingIcebergWriterCompatV1OnExistingTable(TableConfig.ICEBERG_WRITER_COMPAT_V1_ENABLED.getKey());
            }
            if (bl2 && !bl3) {
                throw DeltaErrors.disablingIcebergWriterCompatV1OnExistingTable(TableConfig.ICEBERG_WRITER_COMPAT_V1_ENABLED.getKey());
            }
        }
    }

    public static Optional<Metadata> validateAndUpdateIcebergWriterCompatV1Metadata(boolean bl, Metadata metadata, Protocol protocol) {
        return INSTANCE.validateAndUpdateMetadata(new IcebergCompatMetadataValidatorAndUpdater.IcebergCompatInputContext(bl, metadata, protocol));
    }

    @Override
    String compatFeatureName() {
        return "icebergWriterCompatV1";
    }

    @Override
    TableConfig<Boolean> requiredDeltaTableProperty() {
        return TableConfig.ICEBERG_WRITER_COMPAT_V1_ENABLED;
    }

    @Override
    List<IcebergCompatMetadataValidatorAndUpdater.IcebergCompatRequiredTablePropertyEnforcer> requiredDeltaTableProperties() {
        return Stream.of(CM_ID_MODE_ENABLED, ICEBERG_COMPAT_V2_ENABLED).collect(Collectors.toList());
    }

    @Override
    List<TableFeature> requiredDependencyTableFeatures() {
        return Stream.of(TableFeatures.ICEBERG_WRITER_COMPAT_V1, TableFeatures.ICEBERG_COMPAT_V2_W_FEATURE, TableFeatures.COLUMN_MAPPING_RW_FEATURE).collect(Collectors.toList());
    }

    @Override
    List<IcebergCompatMetadataValidatorAndUpdater.IcebergCompatCheck> icebergCompatChecks() {
        return Stream.of(UNSUPPORTED_FEATURES_CHECK, UNSUPPORTED_TYPES_CHECK, PHYSICAL_NAMES_MATCH_FIELD_IDS_CHECK, INVARIANTS_INACTIVE_CHECK, CHANGE_DATA_FEED_INACTIVE_CHECK, CHECK_CONSTRAINTS_INACTIVE_CHECK, IDENTITY_COLUMNS_INACTIVE_CHECK, GENERATED_COLUMNS_INACTIVE_CHECK).collect(Collectors.toList());
    }
}

