/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.checksum;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.DomainMetadata;
import io.delta.kernel.internal.actions.SingleAction;
import io.delta.kernel.internal.checksum.CRCInfo;
import io.delta.kernel.internal.checksum.ChecksumWriter;
import io.delta.kernel.internal.replay.CreateCheckpointIterator;
import io.delta.kernel.internal.stats.FileSizeHistogram;
import io.delta.kernel.internal.util.Preconditions;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumUtils {
    private static final Logger logger = LoggerFactory.getLogger(ChecksumUtils.class);
    private static final int ADD_INDEX = SingleAction.CHECKPOINT_SCHEMA.indexOf("add");
    private static final int REMOVE_INDEX = SingleAction.CHECKPOINT_SCHEMA.indexOf("remove");
    private static final int DOMAIN_METADATA_INDEX = SingleAction.CHECKPOINT_SCHEMA.indexOf("domainMetadata");
    private static final int ADD_SIZE_INDEX = AddFile.FULL_SCHEMA.indexOf("size");

    private ChecksumUtils() {
    }

    public static void computeStateAndWriteChecksum(Engine engine, SnapshotImpl snapshotImpl) throws IOException {
        if (snapshotImpl.getCurrentCrcInfo().isPresent()) {
            logger.info("Checksum file already exists for version {}", (Object)snapshotImpl.getVersion());
            return;
        }
        LongAdder longAdder = new LongAdder();
        LongAdder longAdder2 = new LongAdder();
        FileSizeHistogram fileSizeHistogram = FileSizeHistogram.createDefaultHistogram();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ChecksumWriter checksumWriter = new ChecksumWriter(snapshotImpl.getLogPath());
        try (CreateCheckpointIterator createCheckpointIterator = new CreateCheckpointIterator(engine, snapshotImpl.getLogSegment(), Instant.ofEpochMilli(Long.MAX_VALUE).toEpochMilli());){
            while (createCheckpointIterator.hasNext()) {
                FilteredColumnarBatch filteredColumnarBatch = createCheckpointIterator.next();
                ColumnarBatch columnarBatch = filteredColumnarBatch.getData();
                Optional<ColumnVector> optional = filteredColumnarBatch.getSelectionVector();
                int n = columnarBatch.getSize();
                ColumnVector columnVector2 = columnarBatch.getColumnVector(REMOVE_INDEX);
                ColumnVector columnVector3 = columnarBatch.getColumnVector(ADD_INDEX);
                ColumnVector columnVector4 = columnarBatch.getColumnVector(DOMAIN_METADATA_INDEX);
                for (int i = 0; i < n; ++i) {
                    Object object;
                    int n2 = i;
                    boolean bl = optional.map(columnVector -> !columnVector.isNullAt(n2) && columnVector.getBoolean(n2)).orElse(true);
                    if (!bl) continue;
                    Preconditions.checkState(columnVector2.isNullAt(i), "unexpected remove row found when setting minFileRetentionTimestampMillis to infinite future");
                    if (!columnVector3.isNullAt(i)) {
                        object = columnVector3.getChild(ADD_SIZE_INDEX);
                        long l = object.getLong(i);
                        longAdder.add(l);
                        fileSizeHistogram.insert(l);
                        longAdder2.increment();
                    }
                    if (columnVector4.isNullAt(i) || (object = DomainMetadata.fromColumnVector(columnVector4, i)) == null) continue;
                    Preconditions.checkState(!hashMap.containsKey(((DomainMetadata)object).getDomain()), "unexpected duplicate domain metadata rows");
                    if (((DomainMetadata)object).isRemoved()) continue;
                    hashMap.put(((DomainMetadata)object).getDomain(), object);
                }
            }
            try {
                checksumWriter.writeCheckSum(engine, new CRCInfo(snapshotImpl.getVersion(), snapshotImpl.getMetadata(), snapshotImpl.getProtocol(), longAdder.longValue(), longAdder2.longValue(), Optional.empty(), Optional.of(new HashSet(hashMap.values())), Optional.of(fileSizeHistogram)));
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                logger.info("Checksum file already exists for version {}", (Object)snapshotImpl.getVersion());
            }
        }
    }
}

