/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.actions.Format;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.internal.lang.Lazy;
import io.delta.kernel.internal.types.DataTypeJsonSerDe;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Metadata {
    public static final StructType FULL_SCHEMA = new StructType().add("id", (DataType)StringType.STRING, false).add("name", (DataType)StringType.STRING, true).add("description", (DataType)StringType.STRING, true).add("format", (DataType)Format.FULL_SCHEMA, false).add("schemaString", (DataType)StringType.STRING, false).add("partitionColumns", (DataType)new ArrayType(StringType.STRING, false), false).add("createdTime", (DataType)LongType.LONG, true).add("configuration", (DataType)new MapType(StringType.STRING, StringType.STRING, false), false);
    private final String id;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Format format;
    private final String schemaString;
    private final StructType schema;
    private final ArrayValue partitionColumns;
    private final Optional<Long> createdTime;
    private final MapValue configurationMapValue;
    private final Lazy<Map<String, String>> configuration;
    private final Lazy<Set<String>> partitionColNames;
    private final Lazy<StructType> dataSchema;

    public static Metadata fromRow(Row row) {
        Objects.requireNonNull(row);
        Preconditions.checkArgument(FULL_SCHEMA.equals(row.getSchema()));
        return Metadata.fromColumnVector(VectorUtils.buildColumnVector(Collections.singletonList(row), FULL_SCHEMA), 0);
    }

    public static Metadata fromColumnVector(ColumnVector columnVector, int n) {
        if (columnVector.isNullAt(n)) {
            return null;
        }
        String string = InternalUtils.requireNonNull(columnVector.getChild(4), n, "schemaString").getString(n);
        StructType structType = DataTypeJsonSerDe.deserializeStructType(string);
        return new Metadata(InternalUtils.requireNonNull(columnVector.getChild(0), n, "id").getString(n), Optional.ofNullable(columnVector.getChild(1).isNullAt(n) ? null : columnVector.getChild(1).getString(n)), Optional.ofNullable(columnVector.getChild(2).isNullAt(n) ? null : columnVector.getChild(2).getString(n)), Format.fromColumnVector(InternalUtils.requireNonNull(columnVector.getChild(3), n, "format"), n), string, structType, columnVector.getChild(5).getArray(n), Optional.ofNullable(columnVector.getChild(6).isNullAt(n) ? null : Long.valueOf(columnVector.getChild(6).getLong(n))), columnVector.getChild(7).getMap(n));
    }

    public Metadata(String string, Optional<String> optional, Optional<String> optional2, Format format, String string2, StructType structType, ArrayValue arrayValue, Optional<Long> optional3, MapValue mapValue) {
        this.id = Objects.requireNonNull(string, "id is null");
        this.name = optional;
        this.description = Objects.requireNonNull(optional2, "description is null");
        this.format = Objects.requireNonNull(format, "format is null");
        this.schemaString = Objects.requireNonNull(string2, "schemaString is null");
        this.schema = structType;
        this.partitionColumns = Objects.requireNonNull(arrayValue, "partitionColumns is null");
        this.createdTime = optional3;
        this.configurationMapValue = Objects.requireNonNull(mapValue, "configuration is null");
        this.configuration = new Lazy<Map>(() -> VectorUtils.toJavaMap(mapValue));
        this.partitionColNames = new Lazy<Set>(this::loadPartitionColNames);
        this.dataSchema = new Lazy<StructType>(() -> new StructType(structType.fields().stream().filter(structField -> !this.partitionColNames.get().contains(structField.getName().toLowerCase(Locale.ROOT))).collect(Collectors.toList())));
    }

    public Metadata withMergedConfiguration(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.getConfiguration());
        hashMap.putAll(map);
        return this.withReplacedConfiguration(hashMap);
    }

    public Metadata withConfigurationKeysUnset(Set<String> set) {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.getConfiguration());
        set.forEach(hashMap::remove);
        return this.withReplacedConfiguration(hashMap);
    }

    public Metadata withReplacedConfiguration(Map<String, String> map) {
        return new Metadata(this.id, this.name, this.description, this.format, this.schemaString, this.schema, this.partitionColumns, this.createdTime, VectorUtils.stringStringMapValue(map));
    }

    public Metadata withNewSchema(StructType structType) {
        return new Metadata(this.id, this.name, this.description, this.format, structType.toJson(), structType, this.partitionColumns, this.createdTime, this.configurationMapValue);
    }

    public String toString() {
        List<String> list = VectorUtils.toJavaList(this.partitionColumns);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("List(");
        for (String string : list) {
            stringBuilder.append(string).append(", ");
        }
        if (stringBuilder.substring(stringBuilder.length() - 2).equals(", ")) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append(")");
        return "Metadata{id='" + this.id + '\'' + ", name=" + this.name + ", description=" + this.description + ", format=" + this.format + ", schemaString='" + this.schemaString + '\'' + ", partitionColumns=" + stringBuilder + ", createdTime=" + this.createdTime + ", configuration=" + this.configuration.get() + '}';
    }

    public String getSchemaString() {
        return this.schemaString;
    }

    public StructType getSchema() {
        return this.schema;
    }

    public ArrayValue getPartitionColumns() {
        return this.partitionColumns;
    }

    public Set<String> getPartitionColNames() {
        return this.partitionColNames.get();
    }

    public StructType getDataSchema() {
        return this.dataSchema.get();
    }

    public String getId() {
        return this.id;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public Format getFormat() {
        return this.format;
    }

    public Optional<Long> getCreatedTime() {
        return this.createdTime;
    }

    public MapValue getConfigurationMapValue() {
        return this.configurationMapValue;
    }

    public Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration.get());
    }

    public StructType getPhysicalSchema() {
        ColumnMapping.ColumnMappingMode columnMappingMode = ColumnMapping.getColumnMappingMode(this.getConfiguration());
        return ColumnMapping.convertToPhysicalSchema(this.schema, this.schema, columnMappingMode);
    }

    public Map<String, String> filterOutUnchangedProperties(Map<String, String> map) {
        Map<String, String> map2 = this.getConfiguration();
        return map.entrySet().stream().filter(entry -> !map2.containsKey(entry.getKey()) || !((String)map2.get(entry.getKey())).equals(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Row toRow() {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(0, this.id);
        hashMap.put(1, this.name.orElse(null));
        hashMap.put(2, this.description.orElse(null));
        hashMap.put(3, this.format.toRow());
        hashMap.put(4, this.schemaString);
        hashMap.put(5, this.partitionColumns);
        hashMap.put(6, this.createdTime.orElse(null));
        hashMap.put(7, this.configurationMapValue);
        return new GenericRow(FULL_SCHEMA, hashMap);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.format, this.schema, this.partitionColNames, this.createdTime, this.configuration);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Metadata)) {
            return false;
        }
        Metadata metadata = (Metadata)object;
        return this.id.equals(metadata.id) && this.name.equals(metadata.name) && this.description.equals(metadata.description) && this.format.equals(metadata.format) && this.schema.equals(metadata.schema) && this.partitionColNames.get().equals(metadata.partitionColNames.get()) && this.createdTime.equals(metadata.createdTime) && this.configuration.get().equals(metadata.configuration.get());
    }

    private Set<String> loadPartitionColNames() {
        ColumnVector columnVector = this.partitionColumns.getElements();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.partitionColumns.getSize(); ++i) {
            Preconditions.checkArgument(!columnVector.isNullAt(i), "Expected a non-null partition column name");
            String string = columnVector.getString(i);
            Preconditions.checkArgument(string != null && !string.isEmpty(), "Expected non-null and non-empty partition column name");
            hashSet.add(string.toLowerCase(Locale.ROOT));
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

