/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Operation;
import io.delta.kernel.Scan;
import io.delta.kernel.Transaction;
import io.delta.kernel.TransactionCommitResult;
import io.delta.kernel.data.Row;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.ConcurrentWriteException;
import io.delta.kernel.exceptions.DomainDoesNotExistException;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.hook.PostCommitHook;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.DeltaErrorsInternal;
import io.delta.kernel.internal.InternalScanFileUtils;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.CommitInfo;
import io.delta.kernel.internal.actions.DomainMetadata;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.actions.RemoveFile;
import io.delta.kernel.internal.actions.SetTransaction;
import io.delta.kernel.internal.actions.SingleAction;
import io.delta.kernel.internal.annotation.VisibleForTesting;
import io.delta.kernel.internal.checksum.CRCInfo;
import io.delta.kernel.internal.clustering.ClusteringUtils;
import io.delta.kernel.internal.compaction.LogCompactionWriter;
import io.delta.kernel.internal.data.TransactionStateRow;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.hook.CheckpointHook;
import io.delta.kernel.internal.hook.ChecksumFullHook;
import io.delta.kernel.internal.hook.ChecksumSimpleHook;
import io.delta.kernel.internal.hook.LogCompactionHook;
import io.delta.kernel.internal.metrics.TransactionMetrics;
import io.delta.kernel.internal.metrics.TransactionReportImpl;
import io.delta.kernel.internal.replay.ConflictChecker;
import io.delta.kernel.internal.stats.FileSizeHistogram;
import io.delta.kernel.internal.tablefeatures.TableFeatures;
import io.delta.kernel.internal.util.Clock;
import io.delta.kernel.internal.util.DomainMetadataUtils;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.InCommitTimestampUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.SchemaUtils;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.metrics.TransactionMetricsResult;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterable;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionImpl
implements Transaction {
    private static final Logger logger = LoggerFactory.getLogger(TransactionImpl.class);
    public static final int DEFAULT_READ_VERSION = 1;
    public static final int DEFAULT_WRITE_VERSION = 2;
    private final UUID txnId = UUID.randomUUID();
    private final boolean isCreateOrReplace;
    private final String engineInfo;
    private final Operation operation;
    private final Path dataPath;
    private final Path logPath;
    private final Protocol protocol;
    private final SnapshotImpl readSnapshot;
    private final Optional<SetTransaction> setTxnOpt;
    private final Optional<List<Column>> clusteringColumnsOpt;
    private final boolean shouldUpdateProtocol;
    private final Clock clock;
    private final DomainMetadataState domainMetadataState = new DomainMetadataState();
    private Metadata metadata;
    private boolean shouldUpdateMetadata;
    private int maxRetries;
    private int logCompactionInterval;
    private Optional<CRCInfo> currentCrcInfo;
    private boolean closed;

    public TransactionImpl(boolean bl, Path path, Path path2, SnapshotImpl snapshotImpl, String string, Operation operation, Protocol protocol, Metadata metadata, Optional<SetTransaction> optional, Optional<List<Column>> optional2, boolean bl2, boolean bl3, int n, int n2, Clock clock) {
        this.isCreateOrReplace = bl;
        this.dataPath = path;
        this.logPath = path2;
        this.readSnapshot = snapshotImpl;
        this.engineInfo = string;
        this.operation = operation;
        this.protocol = protocol;
        this.metadata = metadata;
        this.setTxnOpt = optional;
        this.clusteringColumnsOpt = optional2;
        this.shouldUpdateMetadata = bl2;
        this.shouldUpdateProtocol = bl3;
        this.maxRetries = n;
        this.logCompactionInterval = n2;
        this.clock = clock;
        this.currentCrcInfo = snapshotImpl.getCurrentCrcInfo();
    }

    @Override
    public Row getTransactionState(Engine engine) {
        return TransactionStateRow.of(this.metadata, this.dataPath.toString(), this.maxRetries);
    }

    @Override
    public List<String> getPartitionColumns(Engine engine) {
        return VectorUtils.toJavaList(this.metadata.getPartitionColumns());
    }

    @Override
    public StructType getSchema(Engine engine) {
        return this.metadata.getSchema();
    }

    @Override
    public long getReadTableVersion() {
        return this.readSnapshot.getVersion();
    }

    public Optional<SetTransaction> getSetTxnOpt() {
        return this.setTxnOpt;
    }

    @VisibleForTesting
    public void addDomainMetadataInternal(String string, String string2) {
        this.domainMetadataState.addDomain(string, string2);
    }

    @Override
    public void addDomainMetadata(String string, String string2) {
        Preconditions.checkState(TableFeatures.isDomainMetadataSupported(this.protocol), "Unable to add domain metadata when the domain metadata table feature is disabled");
        Preconditions.checkArgument(DomainMetadata.isUserControlledDomain(string), "Setting a system-controlled domain is not allowed: " + string);
        this.domainMetadataState.addDomain(string, string2);
    }

    @VisibleForTesting
    public void removeDomainMetadataInternal(String string) {
        this.domainMetadataState.removeDomain(string);
    }

    @Override
    public void removeDomainMetadata(String string) {
        Preconditions.checkState(TableFeatures.isDomainMetadataSupported(this.protocol), "Unable to add domain metadata when the domain metadata table feature is disabled");
        Preconditions.checkArgument(DomainMetadata.isUserControlledDomain(string), "Removing a system-controlled domain is not allowed: " + string);
        this.domainMetadataState.removeDomain(string);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public TransactionCommitResult commit(Engine engine, CloseableIterable<Row> closeableIterable) throws ConcurrentWriteException {
        Preconditions.checkState(!this.closed, "Transaction is already attempted to commit. Create a new transaction.");
        TransactionMetrics transactionMetrics = this.readSnapshot.getVersion() < 0L ? TransactionMetrics.forNewTable() : TransactionMetrics.withExistingTableFileSizeHistogram(this.readSnapshot.getCurrentCrcInfo().flatMap(CRCInfo::getFileSizeHistogram));
        try {
            long l = transactionMetrics.totalCommitTimer.time(() -> this.commitWithRetry(engine, closeableIterable, transactionMetrics));
            this.recordTransactionReport(engine, Optional.of(l), transactionMetrics, Optional.empty());
            TransactionMetricsResult transactionMetricsResult = transactionMetrics.captureTransactionMetricsResult();
            return new TransactionCommitResult(l, this.generatePostCommitHooks(l, transactionMetricsResult), transactionMetricsResult);
        }
        catch (Exception exception) {
            this.recordTransactionReport(engine, Optional.empty(), transactionMetrics, Optional.of(exception));
            throw exception;
        }
    }

    /*
     * Exception decompiling
     */
    private long commitWithRetry(Engine var1_1, CloseableIterable<Row> var2_2, TransactionMetrics var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ConflictChecker.TransactionRebaseState resolveConflicts(Engine engine, long l, CommitInfo commitInfo, int n, CloseableIterable<Row> closeableIterable) {
        logger.info("Table {}, trying to resolve conflicts and retry commit. (tries/maxRetries: {}/{})", new Object[]{this.dataPath, n, this.maxRetries});
        ConflictChecker.TransactionRebaseState transactionRebaseState = ConflictChecker.resolveConflicts(engine, this.readSnapshot, l, this, this.domainMetadataState.getComputedDomainMetadatasToCommit(), closeableIterable);
        long l2 = transactionRebaseState.getLatestVersion() + 1L;
        Preconditions.checkArgument(l < l2, "New commit version %d should be greater than the previous commit attempt version %d.", l2, l);
        Optional<Long> optional = this.getUpdatedInCommitTimestampAfterConflict(transactionRebaseState.getLatestCommitTimestamp(), commitInfo.getInCommitTimestamp());
        this.updateMetadataWithICTIfRequired(engine, optional, transactionRebaseState.getLatestVersion());
        commitInfo.setInCommitTimestamp(optional);
        return transactionRebaseState;
    }

    private void updateMetadata(Metadata metadata) {
        logger.info("Updated metadata from {} to {}", this.shouldUpdateMetadata ? this.metadata : "-", (Object)metadata);
        this.metadata = metadata;
        this.shouldUpdateMetadata = true;
    }

    private void updateMetadataWithICTIfRequired(Engine engine, Optional<Long> optional, long l) {
        optional.ifPresent(l2 -> {
            Optional<Metadata> optional = InCommitTimestampUtils.getUpdatedMetadataWithICTEnablementInfo(engine, l2, this.readSnapshot, this.metadata, l + 1L);
            optional.ifPresent(this::updateMetadata);
        });
    }

    private Optional<Long> getUpdatedInCommitTimestampAfterConflict(long l, Optional<Long> optional) {
        if (optional.isPresent()) {
            long l2 = Math.max(optional.get(), l + 1L);
            return Optional.of(l2);
        }
        return optional;
    }

    private long doCommit(Engine engine, long l, CommitInfo commitInfo, CloseableIterable<Row> closeableIterable, TransactionMetrics transactionMetrics) throws FileAlreadyExistsException {
        long l2;
        block12: {
            ArrayList<Row> arrayList = new ArrayList<Row>();
            arrayList.add(SingleAction.createCommitInfoSingleAction(commitInfo.toRow()));
            if (this.shouldUpdateMetadata) {
                arrayList.add(SingleAction.createMetadataSingleAction(this.metadata.toRow()));
            }
            if (this.shouldUpdateProtocol) {
                arrayList.add(SingleAction.createProtocolSingleAction(this.protocol.toRow()));
            }
            this.setTxnOpt.ifPresent(setTransaction -> arrayList.add(SingleAction.createTxnSingleAction(setTransaction.toRow())));
            List<DomainMetadata> list = this.domainMetadataState.getComputedDomainMetadatasToCommit();
            DomainMetadataUtils.validateDomainMetadatas(list, this.protocol);
            list.forEach(domainMetadata -> arrayList.add(SingleAction.createDomainMetadataSingleAction(domainMetadata.toRow())));
            CloseableIterator<Row> closeableIterator = closeableIterable.iterator();
            try {
                CloseableIterator<Row> closeableIterator2 = this.isReplaceTable() ? this.getRemoveActionsForReplace(engine).combine(closeableIterator) : closeableIterator;
                CloseableIterator<Row> closeableIterator3 = Utils.toCloseableIterator(arrayList.iterator()).combine(closeableIterator2);
                if (l == 0L && !DeltaErrors.wrapEngineExceptionThrowsIO(() -> engine.getFileSystemClient().mkdirs(this.logPath.toString()), "Creating directories for path %s", this.logPath).booleanValue()) {
                    throw new RuntimeException("Failed to create delta log directory: " + this.logPath);
                }
                boolean bl = TableConfig.APPEND_ONLY_ENABLED.fromMetadata(this.metadata);
                DeltaErrors.wrapEngineExceptionThrowsIO(() -> {
                    engine.getJsonHandler().writeJsonFileAtomically(FileNames.deltaFile(this.logPath, l), closeableIterator3.map(row -> {
                        this.incrementMetricsForFileActionRow(transactionMetrics, (Row)row);
                        if (!row.isNullAt(SingleAction.REMOVE_FILE_ORDINAL)) {
                            RemoveFile removeFile = new RemoveFile(row.getStruct(SingleAction.REMOVE_FILE_ORDINAL));
                            if (bl && removeFile.getDataChange()) {
                                throw DeltaErrors.cannotModifyAppendOnlyTable(this.dataPath.toString());
                            }
                        }
                        return row;
                    }), false);
                    return null;
                }, "Write file actions to JSON log file `%s`", FileNames.deltaFile(this.logPath, l));
                l2 = l;
                if (closeableIterator == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (closeableIterator != null) {
                        try {
                            closeableIterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    throw fileAlreadyExistsException;
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
            }
            closeableIterator.close();
        }
        return l2;
    }

    private void incrementMetricsForFileActionRow(TransactionMetrics transactionMetrics, Row row) {
        transactionMetrics.totalActionsCounter.increment();
        if (!row.isNullAt(SingleAction.ADD_FILE_ORDINAL)) {
            transactionMetrics.updateForAddFile(new AddFile(row.getStruct(SingleAction.ADD_FILE_ORDINAL)).getSize());
        } else if (!row.isNullAt(SingleAction.REMOVE_FILE_ORDINAL)) {
            RemoveFile removeFile = new RemoveFile(row.getStruct(SingleAction.REMOVE_FILE_ORDINAL));
            long l = removeFile.getSize().orElseThrow(DeltaErrorsInternal::missingRemoveFileSizeDuringCommit);
            transactionMetrics.updateForRemoveFile(l);
        }
    }

    public boolean isBlindAppend() {
        return false;
    }

    private List<PostCommitHook> generatePostCommitHooks(long l, TransactionMetricsResult transactionMetricsResult) {
        Optional<CRCInfo> optional;
        ArrayList<PostCommitHook> arrayList = new ArrayList<PostCommitHook>();
        if (this.isReadyForCheckpoint(l)) {
            arrayList.add(new CheckpointHook(this.dataPath, l));
        }
        if ((optional = this.buildPostCommitCrcInfoIfCurrentCrcAvailable(l, transactionMetricsResult)).isPresent()) {
            arrayList.add(new ChecksumSimpleHook(optional.get(), this.logPath));
        } else {
            arrayList.add(new ChecksumFullHook(this.dataPath, l));
        }
        if (this.logCompactionInterval > 0 && LogCompactionWriter.shouldCompact(l, this.logCompactionInterval)) {
            long l2 = l + 1L - (long)this.logCompactionInterval;
            long l3 = this.clock.getTimeMillis() - TableConfig.TOMBSTONE_RETENTION.fromMetadata(this.metadata);
            arrayList.add(new LogCompactionHook(this.dataPath, this.logPath, l2, l, l3));
        }
        return arrayList;
    }

    private Optional<Long> generateInCommitTimestampForFirstCommitAttempt(Engine engine, long l) {
        if (TableConfig.IN_COMMIT_TIMESTAMPS_ENABLED.fromMetadata(this.metadata).booleanValue()) {
            long l2 = this.readSnapshot.getTimestamp(engine);
            return Optional.of(Math.max(l, l2 + 1L));
        }
        return Optional.empty();
    }

    private CommitInfo generateCommitAction(Engine engine) {
        long l = this.clock.getTimeMillis();
        return new CommitInfo(this.generateInCommitTimestampForFirstCommitAttempt(engine, l), l, "Kernel-4.0.0/" + this.engineInfo, this.operation.getDescription(), this.getOperationParameters(), this.isBlindAppend(), this.txnId.toString(), Collections.emptyMap());
    }

    private boolean isReadyForCheckpoint(long l) {
        int n = TableConfig.CHECKPOINT_INTERVAL.fromMetadata(this.metadata);
        return l > 0L && l % (long)n == 0L;
    }

    private Map<String, String> getOperationParameters() {
        if (this.isCreateOrReplace) {
            List list = VectorUtils.toJavaList(this.metadata.getPartitionColumns());
            String string2 = list.stream().map(string -> "\"" + string + "\"").collect(Collectors.joining(",", "[", "]"));
            return Collections.singletonMap("partitionBy", string2);
        }
        return Collections.emptyMap();
    }

    private void recordTransactionReport(Engine engine, Optional<Long> optional, TransactionMetrics transactionMetrics, Optional<Exception> optional2) {
        TransactionReportImpl transactionReportImpl = new TransactionReportImpl(this.dataPath.toString(), this.operation.toString(), this.engineInfo, optional, transactionMetrics, this.readSnapshot.getSnapshotReport(), optional2);
        engine.getMetricsReporters().forEach(metricsReporter -> metricsReporter.report(transactionReportImpl));
    }

    private Optional<CRCInfo> buildPostCommitCrcInfoIfCurrentCrcAvailable(long l, TransactionMetricsResult transactionMetricsResult) {
        if (this.isCreateOrReplace) {
            return Optional.of(new CRCInfo(l, this.metadata, this.protocol, transactionMetricsResult.getTotalAddFilesSizeInBytes(), transactionMetricsResult.getNumAddFiles(), Optional.of(this.txnId.toString()), this.domainMetadataState.getPostCommitDomainMetadatas(), transactionMetricsResult.getTableFileSizeHistogram().map(FileSizeHistogram::fromFileSizeHistogramResult)));
        }
        return this.currentCrcInfo.filter(cRCInfo -> l == cRCInfo.getVersion() + 1L).map(cRCInfo -> new CRCInfo(l, this.metadata, this.protocol, cRCInfo.getTableSizeBytes() + transactionMetricsResult.getTotalAddFilesSizeInBytes() - transactionMetricsResult.getTotalRemoveFilesSizeInBytes(), cRCInfo.getNumFiles() + transactionMetricsResult.getNumAddFiles() - transactionMetricsResult.getNumRemoveFiles(), Optional.of(this.txnId.toString()), this.domainMetadataState.getPostCommitDomainMetadatas(), transactionMetricsResult.getTableFileSizeHistogram().map(FileSizeHistogram::fromFileSizeHistogramResult)));
    }

    public static List<Column> getStatisticsColumns(Row row) {
        int n = TableConfig.DATA_SKIPPING_NUM_INDEXED_COLS.fromMetadata(TransactionStateRow.getConfiguration(row));
        HashSet<String> hashSet = new HashSet<String>(TransactionStateRow.getPartitionColumnsList(row));
        return SchemaUtils.collectLeafColumns(TransactionStateRow.getPhysicalSchema(row), hashSet, n);
    }

    private CloseableIterator<Row> getRemoveActionsForReplace(Engine engine) {
        Preconditions.checkArgument(this.readSnapshot.getVersion() >= 0L, "Cannot generate removes for a snapshot with version < 0");
        Scan scan = this.readSnapshot.getScanBuilder().build();
        return Utils.intoRows(scan.getScanFiles(engine)).map(row -> {
            AddFile addFile = new AddFile(row.getStruct(InternalScanFileUtils.ADD_FILE_ORDINAL));
            return SingleAction.createRemoveFileSingleAction(addFile.toRemoveFileRow(true, Optional.empty()));
        });
    }

    private boolean isReplaceTable() {
        return this.isCreateOrReplace && this.readSnapshot.getVersion() >= 0L;
    }

    private class DomainMetadataState {
        private final Map<String, DomainMetadata> domainsToAdd = new HashMap<String, DomainMetadata>();
        private final Set<String> domainsToRemove = new HashSet<String>();
        private Optional<List<DomainMetadata>> computedMetadatas = Optional.empty();

        private DomainMetadataState() {
        }

        public void addDomain(String string, String string2) {
            Preconditions.checkArgument(!this.domainsToRemove.contains(string), "Cannot add a domain that is removed in this transaction");
            Preconditions.checkState(!TransactionImpl.this.closed, "Cannot add a domain metadata after the transaction has completed");
            this.domainsToAdd.put(string, new DomainMetadata(string, string2, false));
            this.computedMetadatas = Optional.empty();
        }

        public void removeDomain(String string) {
            Preconditions.checkArgument(!this.domainsToAdd.containsKey(string), "Cannot remove a domain that is added in this transaction");
            Preconditions.checkState(!TransactionImpl.this.closed, "Cannot remove a domain after the transaction has completed");
            this.domainsToRemove.add(string);
            this.computedMetadatas = Optional.empty();
        }

        public List<DomainMetadata> getComputedDomainMetadatasToCommit() {
            if (this.computedMetadatas.isPresent()) {
                return this.computedMetadatas.get();
            }
            this.generateClusteringDomainMetadataIfNeeded();
            if (TransactionImpl.this.isReplaceTable()) {
                TransactionImpl.this.readSnapshot.getActiveDomainMetadataMap().forEach((string, domainMetadata) -> {
                    if (!this.domainsToAdd.containsKey(string)) {
                        this.removeDomain((String)string);
                    }
                });
            }
            ArrayList<DomainMetadata> arrayList = new ArrayList<DomainMetadata>(this.domainsToAdd.values());
            if (this.domainsToRemove.isEmpty()) {
                this.computedMetadatas = Optional.of(arrayList);
                return arrayList;
            }
            Map<String, DomainMetadata> map = TransactionImpl.this.readSnapshot.getActiveDomainMetadataMap();
            for (String string2 : this.domainsToRemove) {
                if (map.containsKey(string2)) {
                    DomainMetadata domainMetadata2 = map.get(string2);
                    Preconditions.checkState(!domainMetadata2.isRemoved(), "snapshotDomainMetadataMap should only contain active domain metadata");
                    arrayList.add(domainMetadata2.removed());
                    continue;
                }
                throw new DomainDoesNotExistException(TransactionImpl.this.dataPath.toString(), string2, TransactionImpl.this.readSnapshot.getVersion());
            }
            this.computedMetadatas = Optional.of(arrayList);
            return arrayList;
        }

        public void setComputedDomainMetadatas(List<DomainMetadata> list) {
            this.computedMetadatas = Optional.of(list);
        }

        public Optional<Set<DomainMetadata>> getPostCommitDomainMetadatas() {
            if (TransactionImpl.this.readSnapshot.getVersion() < 0L) {
                return Optional.of(this.getComputedDomainMetadatasToCommit().stream().filter(domainMetadata -> !domainMetadata.isRemoved()).collect(Collectors.toSet()));
            }
            return TransactionImpl.this.currentCrcInfo.flatMap(CRCInfo::getDomainMetadata).map(set -> {
                Map map = set.stream().collect(Collectors.toMap(DomainMetadata::getDomain, Function.identity()));
                this.getComputedDomainMetadatasToCommit().forEach(domainMetadata -> {
                    if (domainMetadata.isRemoved()) {
                        map.remove(domainMetadata.getDomain());
                    } else {
                        map.put(domainMetadata.getDomain(), domainMetadata);
                    }
                });
                return new HashSet(map.values());
            });
        }

        private void generateClusteringDomainMetadataIfNeeded() {
            if (TableFeatures.isClusteringTableFeatureSupported(TransactionImpl.this.protocol) && TransactionImpl.this.clusteringColumnsOpt.isPresent()) {
                DomainMetadata domainMetadata = ClusteringUtils.getClusteringDomainMetadata((List)TransactionImpl.this.clusteringColumnsOpt.get());
                this.addDomain(domainMetadata.getDomain(), domainMetadata.getConfiguration());
            } else if (TableFeatures.isClusteringTableFeatureSupported(TransactionImpl.this.protocol) && TransactionImpl.this.isReplaceTable() && !TransactionImpl.this.clusteringColumnsOpt.isPresent()) {
                DomainMetadata domainMetadata = ClusteringUtils.getClusteringDomainMetadata(Collections.emptyList());
                this.addDomain(domainMetadata.getDomain(), domainMetadata.getConfiguration());
            }
        }
    }
}

