/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.data.Row;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.DeletionVectorDescriptor;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.FileStatus;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class InternalScanFileUtils {
    private static final String TABLE_ROOT_COL_NAME = "tableRoot";
    private static final DataType TABLE_ROOT_DATA_TYPE = StringType.STRING;
    public static final Column ADD_FILE_PARTITION_COL_REF = new Column(new String[]{"add", "partitionValues"});
    public static StructField TABLE_ROOT_STRUCT_FIELD = new StructField("tableRoot", TABLE_ROOT_DATA_TYPE, false);
    public static final StructType SCAN_FILE_SCHEMA = new StructType().add("add", AddFile.SCHEMA_WITHOUT_STATS).add(TABLE_ROOT_STRUCT_FIELD);
    public static final StructType SCAN_FILE_SCHEMA_WITH_STATS = new StructType().add("add", AddFile.SCHEMA_WITH_STATS).add(TABLE_ROOT_STRUCT_FIELD);
    public static final int ADD_FILE_ORDINAL = SCAN_FILE_SCHEMA.indexOf("add");
    private static final StructType ADD_FILE_SCHEMA = (StructType)SCAN_FILE_SCHEMA.get("add").getDataType();
    private static final int ADD_FILE_PATH_ORDINAL = ADD_FILE_SCHEMA.indexOf("path");
    private static final int ADD_FILE_PARTITION_VALUES_ORDINAL = ADD_FILE_SCHEMA.indexOf("partitionValues");
    private static final int ADD_FILE_SIZE_ORDINAL = ADD_FILE_SCHEMA.indexOf("size");
    private static final int ADD_FILE_MOD_TIME_ORDINAL = ADD_FILE_SCHEMA.indexOf("modificationTime");
    private static final int ADD_FILE_DATA_CHANGE_ORDINAL = ADD_FILE_SCHEMA.indexOf("dataChange");
    private static final int ADD_FILE_DV_ORDINAL = ADD_FILE_SCHEMA.indexOf("deletionVector");
    private static final int TABLE_ROOT_ORDINAL = SCAN_FILE_SCHEMA.indexOf("tableRoot");
    public static final int ADD_FILE_STATS_ORDINAL = AddFile.SCHEMA_WITH_STATS.indexOf("stats");

    private InternalScanFileUtils() {
    }

    public static FileStatus getAddFileStatus(Row row) {
        Row row2 = InternalScanFileUtils.getAddFileEntry(row);
        String string = row2.getString(ADD_FILE_PATH_ORDINAL);
        long l = row2.getLong(ADD_FILE_SIZE_ORDINAL);
        long l2 = row2.getLong(ADD_FILE_MOD_TIME_ORDINAL);
        String string2 = row.getString(TABLE_ROOT_ORDINAL);
        String string3 = new Path(new Path(URI.create(string2)), new Path(URI.create(string))).toString();
        return FileStatus.of(string3, l, l2);
    }

    public static Map<String, String> getPartitionValues(Row row) {
        Row row2 = InternalScanFileUtils.getAddFileEntry(row);
        return VectorUtils.toJavaMap(row2.getMap(ADD_FILE_PARTITION_VALUES_ORDINAL));
    }

    protected static Row getAddFileEntry(Row row) {
        if (row.isNullAt(ADD_FILE_ORDINAL)) {
            throw new IllegalArgumentException("There is no `add` entry in the scan file row");
        }
        return row.getStruct(ADD_FILE_ORDINAL);
    }

    public static Row generateScanFileRow(final FileStatus fileStatus) {
        final GenericRow genericRow = new GenericRow(ADD_FILE_SCHEMA, (Map<Integer, Object>)new HashMap<Integer, Object>(){
            {
                this.put(ADD_FILE_PATH_ORDINAL, fileStatus.getPath());
                this.put(ADD_FILE_PARTITION_VALUES_ORDINAL, null);
                this.put(ADD_FILE_SIZE_ORDINAL, fileStatus.getSize());
                this.put(ADD_FILE_MOD_TIME_ORDINAL, fileStatus.getModificationTime());
                this.put(ADD_FILE_DATA_CHANGE_ORDINAL, null);
                this.put(ADD_FILE_DV_ORDINAL, null);
            }
        });
        return new GenericRow(SCAN_FILE_SCHEMA, (Map<Integer, Object>)new HashMap<Integer, Object>(){
            {
                this.put(ADD_FILE_ORDINAL, genericRow);
                this.put(TABLE_ROOT_ORDINAL, "/");
            }
        });
    }

    public static DeletionVectorDescriptor getDeletionVectorDescriptorFromRow(Row row) {
        Row row2 = InternalScanFileUtils.getAddFileEntry(row);
        return DeletionVectorDescriptor.fromRow(row2.getStruct(ADD_FILE_DV_ORDINAL));
    }

    public static Column getPartitionValuesParsedRefInAddFile(String string) {
        return new Column(new String[]{"add", "partitionValues_parsed", string});
    }

    public static Optional<Long> getBaseRowId(Row row) {
        Row row2 = InternalScanFileUtils.getAddFileEntry(row);
        return new AddFile(row2).getBaseRowId();
    }

    public static Optional<Long> getDefaultRowCommitVersion(Row row) {
        Row row2 = InternalScanFileUtils.getAddFileEntry(row);
        return new AddFile(row2).getDefaultRowCommitVersion();
    }
}

