/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.expressions;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Evolving
public final class Literal
implements Expression {
    private final Object value;
    private final DataType dataType;

    public static Literal ofBoolean(boolean bl) {
        return new Literal(bl, BooleanType.BOOLEAN);
    }

    public static Literal ofByte(byte by) {
        return new Literal(by, ByteType.BYTE);
    }

    public static Literal ofShort(short s) {
        return new Literal(s, ShortType.SHORT);
    }

    public static Literal ofInt(int n) {
        return new Literal(n, IntegerType.INTEGER);
    }

    public static Literal ofLong(long l) {
        return new Literal(l, LongType.LONG);
    }

    public static Literal ofFloat(float f) {
        return new Literal(Float.valueOf(f), FloatType.FLOAT);
    }

    public static Literal ofDouble(double d) {
        return new Literal(d, DoubleType.DOUBLE);
    }

    public static Literal ofString(String string) {
        return new Literal(string, StringType.STRING);
    }

    public static Literal ofBinary(byte[] byArray) {
        return new Literal(byArray, BinaryType.BINARY);
    }

    public static Literal ofDate(int n) {
        return new Literal(n, DateType.DATE);
    }

    public static Literal ofTimestamp(long l) {
        return new Literal(l, TimestampType.TIMESTAMP);
    }

    public static Literal ofTimestampNtz(long l) {
        return new Literal(l, TimestampNTZType.TIMESTAMP_NTZ);
    }

    public static Literal ofDecimal(BigDecimal bigDecimal, int n, int n2) {
        BigDecimal bigDecimal2 = bigDecimal.setScale(n2);
        Preconditions.checkArgument(bigDecimal2.precision() <= n, "Decimal precision=%s for decimal %s exceeds max precision %s", bigDecimal2.precision(), bigDecimal2, n);
        return new Literal(bigDecimal2, new DecimalType(n, n2));
    }

    public static Literal ofNull(DataType dataType) {
        return new Literal(null, dataType);
    }

    private Literal(Object object, DataType dataType) {
        if (dataType instanceof ArrayType || dataType instanceof MapType || dataType instanceof StructType) {
            throw new IllegalArgumentException(dataType + " is an invalid data type for Literal.");
        }
        this.value = object;
        this.dataType = dataType;
    }

    public Object getValue() {
        return this.value;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Literal literal = (Literal)object;
        return Objects.equals(this.dataType, literal.dataType) && Objects.equals(this.value, literal.value);
    }
}

