/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;

@Description(value="Add a output ImageStream resource to the list of generated resources.")
public class AddDockerImageStreamResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final ImageConfiguration config;
    private final String dockerImageRepository;

    public AddDockerImageStreamResourceDecorator(ImageConfiguration config, String dockerImageRepository) {
        this.config = config;
        this.dockerImageRepository = dockerImageRepository;
    }

    public void visit(KubernetesListBuilder list) {
        ObjectMeta meta = this.getDeploymentMetadata(list, this.config.getName()).orElseGet(ObjectMeta::new);
        if (this.contains(list, "image.openshift.io/v1", "ImageStream", this.config.getName())) {
            return;
        }
        list.addToItems((VisitableBuilder)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(this.config.getName())).withLabels(meta.getLabels())).endMetadata()).withNewSpec().withDockerImageRepository(this.dockerImageRepository)).endSpec());
    }
}

