/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing;

import io.dekorate.DekorateException;
import io.dekorate.project.FileProjectFactory;
import io.dekorate.project.Project;
import io.dekorate.testing.Testing;
import io.dekorate.utils.Serialization;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;

public interface WithProject {
    public static final String PROJECTS = "PROJECTS";
    public static final String PROJECT_YML = ".project.yml";

    public String[] getAdditionalModules(ExtensionContext var1);

    default public List<Project> getProjects(ExtensionContext context) {
        Object projectsInStore = context.getStore(Testing.DEKORATE_STORE).get((Object)PROJECTS);
        if (projectsInStore != null && projectsInStore instanceof List) {
            return (List)projectsInStore;
        }
        try {
            ArrayList<String> projectsLocations = new ArrayList<String>();
            projectsLocations.add(".");
            projectsLocations.addAll(Arrays.asList(this.getAdditionalModules(context)));
            ArrayList<Project> projects = new ArrayList<Project>();
            for (String projectLocation : projectsLocations) {
                new FileProjectFactory();
                Project projectInfo = FileProjectFactory.create((File)new File(projectLocation));
                Path outputPath = Paths.get(projectLocation, new String[0]).resolve(projectInfo.getBuildInfo().getClassOutputDir().getParent());
                Files.walk(outputPath, new FileVisitOption[0]).filter(path -> path.getFileName().toString().endsWith(PROJECT_YML)).map(path -> {
                    try (FileInputStream is = new FileInputStream(path.toFile());){
                        Project project = (Project)Serialization.unmarshal((InputStream)is, Project.class);
                        return project;
                    }
                    catch (IOException e) {
                        throw DekorateException.launderThrowable((Throwable)e);
                    }
                }).forEach(projects::add);
            }
            context.getStore(Testing.DEKORATE_STORE).put((Object)PROJECTS, projects);
            return projects;
        }
        catch (IOException e) {
            throw DekorateException.launderThrowable((Throwable)e);
        }
    }
}

