/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing;

import io.dekorate.DekorateException;
import io.dekorate.testing.WithBaseConfig;
import io.dekorate.testing.WithClosables;
import io.dekorate.testing.WithDiagnostics;
import io.dekorate.testing.WithKubernetesClient;
import io.dekorate.testing.annotation.Named;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public interface WithPod
extends TestInstancePostProcessor,
WithBaseConfig,
WithKubernetesClient,
WithClosables,
WithDiagnostics {
    @Override
    default public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        Arrays.stream(testInstance.getClass().getDeclaredFields()).forEach(f -> this.injectPod(context, testInstance, (Field)f));
    }

    default public void injectPod(ExtensionContext context, Object testInstance, Field field) {
        if (!field.getType().isAssignableFrom(Pod.class)) {
            return;
        }
        if (!Arrays.stream(field.getDeclaredAnnotations()).filter(a -> a.annotationType().getSimpleName().equalsIgnoreCase("Inject")).findAny().isPresent()) {
            return;
        }
        String name = this.namedAnnotation(field).orElseGet(() -> this.getName(context));
        field.setAccessible(true);
        try {
            field.set(testInstance, this.podForName(context, name));
        }
        catch (IllegalAccessException e) {
            throw DekorateException.launderThrowable((Throwable)e);
        }
    }

    default public Pod podForName(ExtensionContext context, String service) {
        KubernetesClient client = this.getKubernetesClient(context);
        Endpoints endpoints = (Endpoints)((Resource)client.endpoints().withName(service)).get();
        if (endpoints != null) {
            Optional<Pod> pod = endpoints.getSubsets().stream().flatMap(s -> s.getAddresses().stream()).filter(a -> a.getTargetRef().getKind().equals("Pod")).map(a -> a.getTargetRef().getName()).map(n -> (Pod)((PodResource)client.pods().withName(n)).get()).findAny();
            if (!pod.isPresent()) {
                this.extensionError(context, "Failed to detect endpoints for service:" + service);
            } else {
                return pod.get();
            }
        }
        return null;
    }

    default public Optional<String> namedAnnotation(Field field) {
        return Arrays.stream(field.getDeclaredAnnotations()).filter(a -> a.annotationType().isAssignableFrom(Named.class)).map(a -> field.getAnnotation(Named.class).value()).findFirst();
    }

    public String getName(ExtensionContext var1);
}

