/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing;

import io.dekorate.BuildServiceFactories;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.project.Project;
import io.dekorate.testing.WithProject;
import io.dekorate.utils.Serialization;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;

public interface WithImageConfig
extends WithProject {
    public static final String CONFIG_YML = "%s.yml";
    public static final String CONFIG_DIR = "config";

    default public <C extends ImageConfiguration> Stream<C> stream(Class<C> type, Project project) {
        Path configDir = project.getBuildInfo().getClassOutputDir().resolve(project.getDekorateMetaDir()).resolve(CONFIG_DIR);
        return BuildServiceFactories.names().stream().map(n -> String.format(CONFIG_YML, n)).map(s -> configDir.resolve((String)s)).filter(p -> p.toFile().exists()).map(p -> (ImageConfiguration)Serialization.unmarshal((File)p.toFile(), ImageConfiguration.class)).filter(BuildServiceFactories.configMatches((Project)project)).filter(i -> type.isInstance(i)).map(i -> i);
    }

    default public boolean hasImageConfig(Project project) {
        return this.stream(ImageConfiguration.class, project).findAny().isPresent();
    }

    default public Optional<ImageConfiguration> getImageConfig(Project project) {
        return this.stream(ImageConfiguration.class, project).findFirst();
    }
}

