/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing;

import io.dekorate.DekorateException;
import io.dekorate.testing.Testing;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;

public interface WithClosables {
    public static final String CLOSABLES = "CLOSEABLES";

    default public List<Closeable> getCloseables(ExtensionContext context) {
        ArrayList closables = context.getStore(Testing.DEKORATE_STORE).get((Object)CLOSABLES);
        if (closables instanceof List) {
            return closables;
        }
        closables = new ArrayList();
        context.getStore(Testing.DEKORATE_STORE).put((Object)CLOSABLES, closables);
        return closables;
    }

    default public void closeAll(ExtensionContext context) {
        this.getCloseables(context).forEach(c -> {
            try {
                c.close();
            }
            catch (IOException e) {
                throw DekorateException.launderThrowable((Throwable)e);
            }
        });
    }
}

