/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing;

import io.dekorate.testing.DiagnosticsService;
import io.dekorate.utils.Generics;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class DiagnosticsFactory<T extends HasMetadata> {
    public abstract DiagnosticsService<T> create(KubernetesClient var1);

    public Class<T> getType() {
        return (Class)Generics.getTypeArguments(DiagnosticsFactory.class, this.getClass()).get(0);
    }

    public static <R extends HasMetadata> Optional<DiagnosticsService<R>> create(KubernetesClient client, Class<R> type) {
        return DiagnosticsFactory.find(type).map(f -> f.create(client));
    }

    private static Stream<DiagnosticsFactory> stream() {
        return StreamSupport.stream(ServiceLoader.load(DiagnosticsFactory.class, DiagnosticsFactory.class.getClassLoader()).spliterator(), false);
    }

    public static <R extends HasMetadata> Optional<DiagnosticsFactory<R>> find(Class<R> type) {
        return DiagnosticsFactory.stream().filter(f -> f.getType().isAssignableFrom(type)).map(f -> f).findFirst();
    }
}

