/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing;

import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.testing.DiagnosticsFactory;
import io.dekorate.testing.DiagnosticsService;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.HashMap;
import java.util.Optional;

public class Diagnostics {
    private Logger logger = LoggerFactory.getLogger();
    private final KubernetesClient client;

    public Diagnostics(KubernetesClient client) {
        this.client = client;
    }

    public void displayAll() {
        ((PodList)this.client.pods().list()).getItems().stream().forEach(p -> this.display(p));
    }

    public <T extends HasMetadata> void display(T resource) {
        Optional<DiagnosticsService<?>> service = DiagnosticsFactory.create(this.client, resource.getClass());
        service.ifPresent(s -> {
            try {
                s.display(resource);
            }
            catch (Exception e) {
                this.logger.error("Error displaying diagnostics for resource:" + resource.getKind() + " " + resource.getMetadata().getName());
                e.printStackTrace();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(Pod pod, Container container) {
        try {
            this.logger.info("Logs of pod: [" + pod.getMetadata().getName() + "], container: [" + container.getName() + "]");
            this.logger.info(((ContainerResource)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(pod.getMetadata().getNamespace())).withName(pod.getMetadata().getName())).inContainer((Object)container.getName())).tailingLines(100).withPrettyOutput().getLog());
        }
        catch (Throwable t) {
            this.logger.error("Failed to read logs, due to:" + t.getMessage());
        }
        finally {
            this.logger.info("---");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void events(Pod pod) {
        try {
            HashMap<String, String> fields = new HashMap<String, String>();
            if (Strings.isNotNullOrEmpty((String)pod.getMetadata().getUid())) {
                fields.put("involvedObject.uid", pod.getMetadata().getUid());
            }
            if (Strings.isNotNullOrEmpty((String)pod.getMetadata().getNamespace())) {
                fields.put("involvedObject.namespace", pod.getMetadata().getNamespace());
            }
            fields.put("involvedObject.name", pod.getMetadata().getName());
            EventList eventList = (EventList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.v1().events().inNamespace(pod.getMetadata().getNamespace())).withFields(fields)).list();
            if (eventList == null) {
                return;
            }
            this.logger.info("Events of pod: [" + pod.getMetadata().getName() + "]");
            for (Event event : eventList.getItems()) {
                this.logger.info(String.format("%s\t\t%s", event.getReason(), event.getMessage()));
            }
        }
        catch (Throwable t) {
            this.logger.error("Failed to read events, due to:" + t.getMessage());
        }
        finally {
            this.logger.info("\t---");
        }
    }
}

