/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing;

import io.dekorate.testing.AbstractDiagonsticsService;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;

public class DeploymentDiagnostics
extends AbstractDiagonsticsService<Deployment> {
    private static final String DEPLOYMENT_STATUS_HEADER_FORMAT = "Deployment: %s [%d/%d]";
    private static final String DEPLOYMENT_STATUS_CONDITIONS_FORMAT = "\t%-20s %-10s %-40s";

    public DeploymentDiagnostics(KubernetesClient client) {
        super(client);
    }

    @Override
    public void display(Deployment deployment) {
        this.LOGGER.info("Diagnostics for kind: [Deployment] with name : [" + deployment.getMetadata().getName() + "].");
        this.displayResourceYaml(deployment);
        this.displayStatus(deployment);
        this.displayEvents(deployment);
    }

    @Override
    public void displayStatus(Deployment deployment) {
        String name = deployment.getMetadata().getName();
        Deployment updated = (Deployment)((RollableScalableResource)this.getKubernetesClient().apps().deployments().withName(name)).get();
        if (updated != null) {
            int readyReplicas = updated.getStatus() != null && updated.getStatus().getReadyReplicas() != null ? updated.getStatus().getReadyReplicas() : 0;
            this.LOGGER.info(String.format(DEPLOYMENT_STATUS_HEADER_FORMAT, name, readyReplicas, updated.getSpec().getReplicas()));
            if (updated.getStatus() != null && updated.getStatus().getConditions() != null) {
                this.LOGGER.info(String.format(DEPLOYMENT_STATUS_CONDITIONS_FORMAT, "Type", "Status", "Message"));
                updated.getStatus().getConditions().forEach(c -> this.LOGGER.info(String.format(DEPLOYMENT_STATUS_CONDITIONS_FORMAT, c.getType(), c.getStatus(), c.getMessage())));
            } else {
                this.LOGGER.error("Failed to retrieve Deployment: [" + name + "]");
            }
        }
    }
}

