/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.source;

import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.common.TrackTypeKt;
import com.otaliastudios.transcoder.internal.utils.ISO6709LocationParser;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.MutableTrackMap;
import com.otaliastudios.transcoder.internal.utils.TrackMapKt;
import com.otaliastudios.transcoder.source.DataSource;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class DefaultDataSource
implements DataSource {
    private static final AtomicInteger ID = new AtomicInteger(0);
    private final Logger LOG = new Logger("DefaultDataSource(" + ID.getAndIncrement() + ")");
    private final MutableTrackMap<MediaFormat> mFormat = TrackMapKt.mutableTrackMapOf(null);
    private final MutableTrackMap<Integer> mIndex = TrackMapKt.mutableTrackMapOf(null);
    private final HashSet<TrackType> mSelectedTracks = new HashSet();
    private final MutableTrackMap<Long> mLastTimestampUs = TrackMapKt.mutableTrackMapOf(0L, 0L);
    private MediaMetadataRetriever mMetadata = null;
    private MediaExtractor mExtractor = null;
    private long mOriginUs = Long.MIN_VALUE;
    private boolean mInitialized = false;
    private long mDontRenderRangeStart = -1L;
    private long mDontRenderRangeEnd = -1L;

    @Override
    public void initialize() {
        this.LOG.i("initialize(): initializing...");
        this.mExtractor = new MediaExtractor();
        try {
            this.initializeExtractor(this.mExtractor);
        }
        catch (IOException e) {
            this.LOG.e("Got IOException while trying to open MediaExtractor.", e);
            throw new RuntimeException(e);
        }
        this.mMetadata = new MediaMetadataRetriever();
        this.initializeRetriever(this.mMetadata);
        int trackCount = this.mExtractor.getTrackCount();
        for (int i = 0; i < trackCount; ++i) {
            MediaFormat format = this.mExtractor.getTrackFormat(i);
            TrackType type = TrackTypeKt.getTrackTypeOrNull(format);
            if (type == null || this.mIndex.has(type)) continue;
            this.mIndex.set(type, i);
            this.mFormat.set(type, format);
        }
        this.mInitialized = true;
    }

    private void initializeLazyProperties() {
        if (this.mOriginUs == Long.MIN_VALUE) {
            this.mOriginUs = this.mExtractor.getSampleTime();
        }
    }

    @Override
    public void deinitialize() {
        this.LOG.i("deinitialize(): deinitializing...");
        try {
            this.mExtractor.release();
        }
        catch (Exception e) {
            this.LOG.w("Could not release extractor:", e);
        }
        try {
            this.mMetadata.release();
        }
        catch (Exception e) {
            this.LOG.w("Could not release metadata:", e);
        }
        this.mSelectedTracks.clear();
        this.mOriginUs = Long.MIN_VALUE;
        this.mLastTimestampUs.reset(0L, 0L);
        this.mFormat.reset(null, null);
        this.mIndex.reset(null, null);
        this.mDontRenderRangeStart = -1L;
        this.mDontRenderRangeEnd = -1L;
        this.mInitialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.mInitialized;
    }

    @Override
    public void selectTrack(@NonNull TrackType type) {
        this.LOG.i("selectTrack(" + (Object)((Object)type) + ")");
        if (!this.mSelectedTracks.contains((Object)type)) {
            this.mSelectedTracks.add(type);
            this.mExtractor.selectTrack(((Integer)this.mIndex.get(type)).intValue());
        }
    }

    @Override
    public void releaseTrack(@NonNull TrackType type) {
        this.LOG.i("releaseTrack(" + (Object)((Object)type) + ")");
        if (this.mSelectedTracks.contains((Object)type)) {
            this.mSelectedTracks.remove((Object)type);
            this.mExtractor.unselectTrack(((Integer)this.mIndex.get(type)).intValue());
        }
    }

    protected abstract void initializeExtractor(@NonNull MediaExtractor var1) throws IOException;

    protected abstract void initializeRetriever(@NonNull MediaMetadataRetriever var1);

    @Override
    public long seekTo(long desiredPositionUs) {
        this.initializeLazyProperties();
        boolean hasVideo = this.mSelectedTracks.contains((Object)TrackType.VIDEO);
        boolean hasAudio = this.mSelectedTracks.contains((Object)TrackType.AUDIO);
        this.LOG.i("seekTo(): seeking to " + (this.mOriginUs + desiredPositionUs) + " originUs=" + this.mOriginUs + " extractorUs=" + this.mExtractor.getSampleTime() + " externalUs=" + desiredPositionUs + " hasVideo=" + hasVideo + " hasAudio=" + hasAudio);
        if (hasVideo && hasAudio) {
            this.mExtractor.unselectTrack(this.mIndex.getAudio().intValue());
            this.LOG.v("seekTo(): unselected AUDIO, seeking to " + (this.mOriginUs + desiredPositionUs) + " (extractorUs=" + this.mExtractor.getSampleTime() + ")");
            this.mExtractor.seekTo(this.mOriginUs + desiredPositionUs, 0);
            this.LOG.v("seekTo(): unselected AUDIO and sought (extractorUs=" + this.mExtractor.getSampleTime() + ")");
            this.mExtractor.selectTrack(this.mIndex.getAudio().intValue());
            this.LOG.v("seekTo(): reselected AUDIO, seeking to extractorUs (extractorUs=" + this.mExtractor.getSampleTime() + ")");
            this.mExtractor.seekTo(this.mExtractor.getSampleTime(), 2);
            this.LOG.v("seekTo(): seek workaround completed. (extractorUs=" + this.mExtractor.getSampleTime() + ")");
        } else {
            this.mExtractor.seekTo(this.mOriginUs + desiredPositionUs, 0);
        }
        this.mDontRenderRangeStart = this.mExtractor.getSampleTime();
        this.mDontRenderRangeEnd = this.mOriginUs + desiredPositionUs;
        if (this.mDontRenderRangeStart > this.mDontRenderRangeEnd) {
            this.mDontRenderRangeStart = this.mDontRenderRangeEnd;
        }
        this.LOG.i("seekTo(): dontRenderRange=" + this.mDontRenderRangeStart + ".." + this.mDontRenderRangeEnd + " (" + (this.mDontRenderRangeEnd - this.mDontRenderRangeStart) + "us)");
        return this.mExtractor.getSampleTime() - this.mOriginUs;
    }

    @Override
    public boolean isDrained() {
        return this.mExtractor.getSampleTrackIndex() < 0;
    }

    @Override
    public boolean canReadTrack(@NonNull TrackType type) {
        return this.mExtractor.getSampleTrackIndex() == ((Integer)this.mIndex.get(type)).intValue();
    }

    @Override
    public void readTrack(@NonNull DataSource.Chunk chunk) {
        TrackType type;
        this.initializeLazyProperties();
        int index = this.mExtractor.getSampleTrackIndex();
        int position = chunk.buffer.position();
        int limit = chunk.buffer.limit();
        int read = this.mExtractor.readSampleData(chunk.buffer, position);
        if (read < 0) {
            throw new IllegalStateException("No samples available! Forgot to call canReadTrack / isDrained?");
        }
        if (position + read > limit) {
            throw new IllegalStateException("MediaExtractor is not respecting the buffer limit. This might cause other issues down the pipeline.");
        }
        chunk.buffer.limit(position + read);
        chunk.buffer.position(position);
        chunk.keyframe = (this.mExtractor.getSampleFlags() & 1) != 0;
        chunk.timeUs = this.mExtractor.getSampleTime();
        chunk.render = chunk.timeUs < this.mDontRenderRangeStart || chunk.timeUs >= this.mDontRenderRangeEnd;
        this.LOG.v("readTrack(): time=" + chunk.timeUs + ", render=" + chunk.render + ", end=" + this.mDontRenderRangeEnd);
        TrackType trackType = this.mIndex.getHasAudio() && this.mIndex.getAudio() == index ? TrackType.AUDIO : (type = this.mIndex.getHasVideo() && this.mIndex.getVideo() == index ? TrackType.VIDEO : null);
        if (type == null) {
            throw new RuntimeException("Unknown type: " + index);
        }
        this.mLastTimestampUs.set(type, chunk.timeUs);
        this.mExtractor.advance();
        if (!chunk.render && this.isDrained()) {
            this.LOG.w("Force rendering the last frame. timeUs=" + chunk.timeUs);
            chunk.render = true;
        }
    }

    @Override
    public long getPositionUs() {
        if (this.mOriginUs == Long.MIN_VALUE) {
            return 0L;
        }
        long last = Math.max(this.mLastTimestampUs.getAudio(), this.mLastTimestampUs.getVideo());
        return last - this.mOriginUs;
    }

    @Override
    @Nullable
    public double[] getLocation() {
        float[] location;
        this.LOG.i("getLocation()");
        String string = this.mMetadata.extractMetadata(23);
        if (string != null && (location = new ISO6709LocationParser().parse(string)) != null) {
            double[] result = new double[]{location[0], location[1]};
            return result;
        }
        return null;
    }

    @Override
    public int getOrientation() {
        this.LOG.i("getOrientation()");
        try {
            return Integer.parseInt(this.mMetadata.extractMetadata(24));
        }
        catch (NumberFormatException ignore) {
            return 0;
        }
    }

    @Override
    public long getDurationUs() {
        try {
            return Long.parseLong(this.mMetadata.extractMetadata(9)) * 1000L;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    @Override
    @Nullable
    public MediaFormat getTrackFormat(@NonNull TrackType type) {
        this.LOG.i("getTrackFormat(" + (Object)((Object)type) + ")");
        return (MediaFormat)this.mFormat.getOrNull(type);
    }
}

