/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.resize;

import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.common.Size;
import com.otaliastudios.transcoder.resize.Resizer;

public class AspectRatioResizer
implements Resizer {
    private final float aspectRatio;

    public AspectRatioResizer(float aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    @Override
    @NonNull
    public Size getOutputSize(@NonNull Size inputSize) {
        float outputRatio;
        float inputRatio = (float)inputSize.getMajor() / (float)inputSize.getMinor();
        float f = outputRatio = this.aspectRatio > 1.0f ? this.aspectRatio : 1.0f / this.aspectRatio;
        if (inputRatio > outputRatio) {
            return new Size(inputSize.getMinor(), (int)(outputRatio * (float)inputSize.getMinor()));
        }
        if (inputRatio < outputRatio) {
            return new Size(inputSize.getMajor(), (int)((float)inputSize.getMajor() / outputRatio));
        }
        return inputSize;
    }
}

