/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.video;

import android.graphics.Bitmap;
import android.media.MediaFormat;
import android.opengl.EGL14;
import android.opengl.GLES20;
import com.otaliastudios.opengl.core.EglCore;
import com.otaliastudios.opengl.core.Egloo;
import com.otaliastudios.opengl.surface.EglOffscreenSurface;
import com.otaliastudios.transcoder.internal.pipeline.BaseStep;
import com.otaliastudios.transcoder.internal.pipeline.Channel;
import com.otaliastudios.transcoder.internal.pipeline.State;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B?\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/otaliastudios/transcoder/internal/video/VideoSnapshots;", "Lcom/otaliastudios/transcoder/internal/pipeline/BaseStep;", "", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel;", "format", "Landroid/media/MediaFormat;", "requests", "", "accuracyUs", "onSnapshot", "Lkotlin/Function2;", "Landroid/graphics/Bitmap;", "", "<init>", "(Landroid/media/MediaFormat;Ljava/util/List;JLkotlin/jvm/functions/Function2;)V", "channel", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel$Companion;", "getChannel", "()Lcom/otaliastudios/transcoder/internal/pipeline/Channel$Companion;", "", "width", "", "height", "core", "Lcom/otaliastudios/opengl/core/EglCore;", "surface", "Lcom/otaliastudios/opengl/surface/EglOffscreenSurface;", "advance", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "state", "Lcom/otaliastudios/transcoder/internal/pipeline/State$Ok;", "release", "lib_release"})
public final class VideoSnapshots
extends BaseStep<Long, Channel, Long, Channel> {
    private final long accuracyUs;
    @NotNull
    private final Function2<Long, Bitmap, Unit> onSnapshot;
    @NotNull
    private final Channel.Companion channel;
    @NotNull
    private final List<Long> requests;
    private final int width;
    private final int height;
    @NotNull
    private final EglCore core;
    @NotNull
    private final EglOffscreenSurface surface;

    /*
     * WARNING - void declaration
     */
    public VideoSnapshots(@NotNull MediaFormat format, @NotNull List<Long> requests, long accuracyUs, @NotNull Function2<? super Long, ? super Bitmap, Unit> onSnapshot) {
        void it;
        EglOffscreenSurface eglOffscreenSurface;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter(requests, (String)"requests");
        Intrinsics.checkNotNullParameter(onSnapshot, (String)"onSnapshot");
        super("VideoSnapshots");
        this.accuracyUs = accuracyUs;
        this.onSnapshot = onSnapshot;
        this.channel = Channel.Companion;
        this.requests = CollectionsKt.toMutableList((Collection)requests);
        this.width = format.getInteger("width");
        this.height = format.getInteger("height");
        this.core = new EglCore(EGL14.EGL_NO_CONTEXT, 1);
        EglOffscreenSurface eglOffscreenSurface2 = eglOffscreenSurface = new EglOffscreenSurface(this.core, this.width, this.height);
        VideoSnapshots videoSnapshots = this;
        boolean bl = false;
        it.makeCurrent();
        videoSnapshots.surface = eglOffscreenSurface;
    }

    @Override
    @NotNull
    public Channel.Companion getChannel() {
        return this.channel;
    }

    @Override
    @NotNull
    public State<Long> advance(@NotNull State.Ok<Long> state) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        if (this.requests.isEmpty()) {
            return state;
        }
        long expectedUs = ((Number)CollectionsKt.first(this.requests)).longValue();
        long deltaUs = Math.abs(expectedUs - ((Number)state.getValue()).longValue());
        if (deltaUs < this.accuracyUs || state instanceof State.Eos && expectedUs > ((Number)((State.Eos)state).getValue()).longValue()) {
            this.getLog().i("Request MATCHED! expectedUs=" + expectedUs + " actualUs=" + state.getValue() + " deltaUs=" + deltaUs);
            CollectionsKt.removeFirst(this.requests);
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.width * this.height * 4);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            GLES20.glReadPixels((int)0, (int)0, (int)this.width, (int)this.height, (int)6408, (int)5121, (Buffer)buffer);
            Egloo.checkGlError((String)"glReadPixels");
            buffer.rewind();
            Bitmap bitmap = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
            Bitmap bitmap2 = bitmap;
            bitmap2.copyPixelsFromBuffer((Buffer)buffer);
            this.onSnapshot.invoke((Object)state.getValue(), (Object)bitmap2);
        } else {
            this.getLog().v("Request has high delta. expectedUs=" + expectedUs + " actualUs=" + state.getValue() + " deltaUs=" + deltaUs);
        }
        return state;
    }

    @Override
    public void release() {
        this.surface.release();
        this.core.release();
    }
}

