/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.utils;

import com.otaliastudios.transcoder.common.TrackType;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002J\u0016\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u00a6\u0002\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0017\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u0014\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0015\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u001a\u001a\f\u0012\b\u0012\u0006\b\u0002\u0018\u00018\u00000\u001bH\u0096\u0002\u00f8\u0001\u0000R\u0014\u0010\u0007\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\u000e\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006\u001c"}, d2={"Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "T", "", "get", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "(Lcom/otaliastudios/transcoder/common/TrackType;)Ljava/lang/Object;", "video", "getVideo", "()Ljava/lang/Object;", "audio", "getAudio", "has", "", "hasVideo", "getHasVideo", "()Z", "hasAudio", "getHasAudio", "getOrNull", "videoOrNull", "audioOrNull", "size", "", "getSize", "()I", "iterator", "", "lib_release"})
public interface TrackMap<T>
extends Iterable<T>,
KMappedMarker {
    public T get(@NotNull TrackType var1);

    public T getVideo();

    public T getAudio();

    public boolean has(@NotNull TrackType var1);

    public boolean getHasVideo();

    public boolean getHasAudio();

    @Nullable
    public T getOrNull(@NotNull TrackType var1);

    @Nullable
    public T videoOrNull();

    @Nullable
    public T audioOrNull();

    public int getSize();

    @Override
    @NotNull
    public Iterator<T> iterator();

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static <T> T getVideo(@NotNull TrackMap<T> $this) {
            return $this.get(TrackType.VIDEO);
        }

        public static <T> T getAudio(@NotNull TrackMap<T> $this) {
            return $this.get(TrackType.AUDIO);
        }

        public static <T> boolean getHasVideo(@NotNull TrackMap<T> $this) {
            return $this.has(TrackType.VIDEO);
        }

        public static <T> boolean getHasAudio(@NotNull TrackMap<T> $this) {
            return $this.has(TrackType.AUDIO);
        }

        @Nullable
        public static <T> T getOrNull(@NotNull TrackMap<T> $this, @NotNull TrackType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return $this.has(type) ? (T)$this.get(type) : null;
        }

        @Nullable
        public static <T> T videoOrNull(@NotNull TrackMap<T> $this) {
            return $this.getOrNull(TrackType.VIDEO);
        }

        @Nullable
        public static <T> T audioOrNull(@NotNull TrackMap<T> $this) {
            return $this.getOrNull(TrackType.AUDIO);
        }

        public static <T> int getSize(@NotNull TrackMap<T> $this) {
            Object[] objectArray = new Object[]{$this.videoOrNull(), $this.audioOrNull()};
            return CollectionsKt.listOfNotNull((Object[])objectArray).size();
        }

        @NotNull
        public static <T> Iterator<T> iterator(@NotNull TrackMap<T> $this) {
            Object[] objectArray = new Object[]{$this.videoOrNull(), $this.audioOrNull()};
            return CollectionsKt.listOfNotNull((Object[])objectArray).iterator();
        }
    }
}

