/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.utils;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Logger {
    public static final int LEVEL_VERBOSE = 0;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_ERROR = 3;
    private static int sLevel = 1;
    private final String mTag;
    private final int mLevel;

    public Logger(@NonNull String tag) {
        this.mTag = tag;
        this.mLevel = sLevel;
    }

    public Logger(@NonNull String tag, int level) {
        this.mTag = tag;
        this.mLevel = level;
    }

    public static void setLogLevel(int logLevel) {
        sLevel = logLevel;
    }

    private boolean should(int messageLevel) {
        return this.mLevel <= messageLevel;
    }

    public void v(String message) {
        this.v(message, null);
    }

    public void i(String message) {
        this.i(message, null);
    }

    public void w(String message) {
        this.w(message, null);
    }

    public void e(String message) {
        this.e(message, null);
    }

    public void v(String message, @Nullable Throwable error) {
        this.log(0, message, error);
    }

    public void i(String message, @Nullable Throwable error) {
        this.log(1, message, error);
    }

    public void w(String message, @Nullable Throwable error) {
        this.log(2, message, error);
    }

    public void e(String message, @Nullable Throwable error) {
        this.log(3, message, error);
    }

    private void log(int level, String message, @Nullable Throwable throwable) {
        if (!this.should(level)) {
            return;
        }
        switch (level) {
            case 0: {
                Log.v((String)this.mTag, (String)message, (Throwable)throwable);
                break;
            }
            case 1: {
                Log.i((String)this.mTag, (String)message, (Throwable)throwable);
                break;
            }
            case 2: {
                Log.w((String)this.mTag, (String)message, (Throwable)throwable);
                break;
            }
            case 3: {
                Log.e((String)this.mTag, (String)message, (Throwable)throwable);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogLevel {
    }
}

