/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.transcode;

import android.media.MediaFormat;
import com.otaliastudios.transcoder.common.TrackStatus;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.Codecs;
import com.otaliastudios.transcoder.internal.DataSources;
import com.otaliastudios.transcoder.internal.Segment;
import com.otaliastudios.transcoder.internal.Segments;
import com.otaliastudios.transcoder.internal.Timer;
import com.otaliastudios.transcoder.internal.Tracks;
import com.otaliastudios.transcoder.internal.pipeline.Pipeline;
import com.otaliastudios.transcoder.internal.pipeline.PipelinesKt;
import com.otaliastudios.transcoder.internal.transcode.TranscodeEngine;
import com.otaliastudios.transcoder.internal.utils.EosKt;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.resample.AudioResampler;
import com.otaliastudios.transcoder.sink.DataSink;
import com.otaliastudios.transcoder.source.DataSource;
import com.otaliastudios.transcoder.strategy.TrackStrategy;
import com.otaliastudios.transcoder.stretch.AudioStretcher;
import com.otaliastudios.transcoder.time.TimeInterpolator;
import com.otaliastudios.transcoder.validator.Validator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u0000 12\u00020\u0001:\u00011BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J0\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020*H\u0016J\u001c\u0010+\u001a\u00020,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020,0.H\u0016J\b\u00100\u001a\u00020,H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/otaliastudios/transcoder/internal/transcode/DefaultTranscodeEngine;", "Lcom/otaliastudios/transcoder/internal/transcode/TranscodeEngine;", "dataSources", "Lcom/otaliastudios/transcoder/internal/DataSources;", "dataSink", "Lcom/otaliastudios/transcoder/sink/DataSink;", "strategies", "Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "Lcom/otaliastudios/transcoder/strategy/TrackStrategy;", "validator", "Lcom/otaliastudios/transcoder/validator/Validator;", "videoRotation", "", "audioStretcher", "Lcom/otaliastudios/transcoder/stretch/AudioStretcher;", "audioResampler", "Lcom/otaliastudios/transcoder/resample/AudioResampler;", "interpolator", "Lcom/otaliastudios/transcoder/time/TimeInterpolator;", "<init>", "(Lcom/otaliastudios/transcoder/internal/DataSources;Lcom/otaliastudios/transcoder/sink/DataSink;Lcom/otaliastudios/transcoder/internal/utils/TrackMap;Lcom/otaliastudios/transcoder/validator/Validator;ILcom/otaliastudios/transcoder/stretch/AudioStretcher;Lcom/otaliastudios/transcoder/resample/AudioResampler;Lcom/otaliastudios/transcoder/time/TimeInterpolator;)V", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "tracks", "Lcom/otaliastudios/transcoder/internal/Tracks;", "segments", "Lcom/otaliastudios/transcoder/internal/Segments;", "timer", "Lcom/otaliastudios/transcoder/internal/Timer;", "codecs", "Lcom/otaliastudios/transcoder/internal/Codecs;", "createPipeline", "Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline;", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "index", "count", "status", "Lcom/otaliastudios/transcoder/common/TrackStatus;", "outputFormat", "Landroid/media/MediaFormat;", "validate", "", "transcode", "", "progress", "Lkotlin/Function1;", "", "cleanup", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nDefaultTranscodeEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultTranscodeEngine.kt\ncom/otaliastudios/transcoder/internal/transcode/DefaultTranscodeEngine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public final class DefaultTranscodeEngine
extends TranscodeEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataSources dataSources;
    @NotNull
    private final DataSink dataSink;
    @NotNull
    private final Validator validator;
    private final int videoRotation;
    @NotNull
    private final AudioStretcher audioStretcher;
    @NotNull
    private final AudioResampler audioResampler;
    @NotNull
    private final Logger log;
    @NotNull
    private final Tracks tracks;
    @NotNull
    private final Segments segments;
    @NotNull
    private final Timer timer;
    @NotNull
    private final Codecs codecs;
    private static final long WAIT_MS = 2L;
    private static final long PROGRESS_LOOPS = 10L;

    public DefaultTranscodeEngine(@NotNull DataSources dataSources, @NotNull DataSink dataSink, @NotNull TrackMap<TrackStrategy> strategies, @NotNull Validator validator, int videoRotation, @NotNull AudioStretcher audioStretcher, @NotNull AudioResampler audioResampler, @NotNull TimeInterpolator interpolator) {
        Intrinsics.checkNotNullParameter((Object)dataSources, (String)"dataSources");
        Intrinsics.checkNotNullParameter((Object)dataSink, (String)"dataSink");
        Intrinsics.checkNotNullParameter(strategies, (String)"strategies");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Intrinsics.checkNotNullParameter((Object)audioStretcher, (String)"audioStretcher");
        Intrinsics.checkNotNullParameter((Object)audioResampler, (String)"audioResampler");
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        this.dataSources = dataSources;
        this.dataSink = dataSink;
        this.validator = validator;
        this.videoRotation = videoRotation;
        this.audioStretcher = audioStretcher;
        this.audioResampler = audioResampler;
        this.log = new Logger("TranscodeEngine");
        this.tracks = new Tracks(strategies, this.dataSources, this.videoRotation, false);
        this.segments = new Segments(this.dataSources, this.tracks, (Function5<? super TrackType, ? super Integer, ? super Integer, ? super TrackStatus, ? super MediaFormat, Pipeline>)((Function5)new Function5<TrackType, Integer, Integer, TrackStatus, MediaFormat, Pipeline>((Object)this){

            public final Pipeline invoke(TrackType p0, int p1, int p2, TrackStatus p3, MediaFormat p4) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                Intrinsics.checkNotNullParameter((Object)((Object)p3), (String)"p3");
                Intrinsics.checkNotNullParameter((Object)p4, (String)"p4");
                return DefaultTranscodeEngine.access$createPipeline((DefaultTranscodeEngine)this.receiver, p0, p1, p2, p3, p4);
            }
        }));
        this.timer = new Timer(interpolator, this.dataSources, this.tracks, (TrackMap<Integer>)this.segments.getCurrentIndex());
        this.codecs = new Codecs(this.dataSources, this.tracks, (TrackMap<Integer>)this.segments.getCurrentIndex());
        this.log.i("Created Tracks, Segments, Timer...");
        this.dataSink.setOrientation(0);
        double[] location = (double[])SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.dataSources.all()), DefaultTranscodeEngine::_init_$lambda$0));
        if (location != null) {
            this.dataSink.setLocation(location[0], location[1]);
        }
        this.dataSink.setTrackStatus(TrackType.VIDEO, this.tracks.getAll().getVideo());
        this.dataSink.setTrackStatus(TrackType.AUDIO, this.tracks.getAll().getAudio());
        this.log.i("Set up the DataSink...");
    }

    private final Pipeline createPipeline(TrackType type, int index, int count, TrackStatus status, MediaFormat outputFormat) {
        this.log.w("createPipeline(" + type + ", " + index + ", " + status + "), format=" + outputFormat);
        Timer.SegmentInterpolator interpolator = this.timer.interpolator(type, index);
        Object sources = this.dataSources.get(type);
        DataSource source = EosKt.forcingEos((DataSource)sources.get(index), (Function0<Boolean>)((Function0)() -> DefaultTranscodeEngine.createPipeline$lambda$1(this, type)));
        DataSink sink = EosKt.ignoringEos(this.dataSink, (Function0<Boolean>)((Function0)() -> DefaultTranscodeEngine.createPipeline$lambda$2(index, (List)sources)));
        return switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1 -> PipelinesKt.EmptyPipeline();
            case 2 -> PipelinesKt.EmptyPipeline();
            case 3 -> PipelinesKt.PassThroughPipeline(type, source, sink, interpolator);
            case 4 -> PipelinesKt.RegularPipeline(type, count > 1 ? index + 1 + "/" + count : null, source, sink, interpolator, outputFormat, this.codecs, this.videoRotation, this.audioStretcher, this.audioResampler);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public boolean validate() {
        if (!this.validator.validate(this.tracks.getAll().getVideo(), this.tracks.getAll().getAudio())) {
            this.log.i("Validator has decided that the input is fine and transcoding is not necessary.");
            return false;
        }
        return true;
    }

    @Override
    public void transcode(@NotNull Function1<? super Double, Unit> progress2) {
        Intrinsics.checkNotNullParameter(progress2, (String)"progress");
        long loop = 0L;
        this.log.i("transcode(): about to start, durationUs=" + this.timer.getTotalDurationUs() + ", audioUs=" + this.timer.getDurationUs().audioOrNull() + ", videoUs=" + this.timer.getDurationUs().videoOrNull());
        while (true) {
            Segment audio = this.segments.next(TrackType.AUDIO);
            Segment video = this.segments.next(TrackType.VIDEO);
            Segment segment = audio;
            Segment segment2 = video;
            boolean advanced = (segment != null ? segment.advance() : false) | (segment2 != null ? segment2.advance() : false);
            boolean completed = !advanced && !this.segments.hasNext();
            this.log.v("iteration #" + loop + " audio=" + (((Number)this.segments.getCurrentIndex().getAudio()).intValue() + 1) + "/" + ((List)this.dataSources.getAudio()).size() + " video=" + (((Number)this.segments.getCurrentIndex().getVideo()).intValue() + 1) + "/" + ((List)this.dataSources.getVideo()).size() + " advanced=" + advanced + " completed=" + completed);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (completed) break;
            if (!advanced) {
                Segment segment3 = audio;
                if (!(segment3 != null ? !segment3.needsSleep() : false)) {
                    Segment segment4 = video;
                    if (!(segment4 != null ? !segment4.needsSleep() : false)) {
                        Thread.sleep(WAIT_MS);
                    }
                }
            }
            if (!advanced || ++loop % PROGRESS_LOOPS != 0L) continue;
            double audioProgress = ((Number)this.timer.getProgress().getAudio()).doubleValue();
            double videoProgress = ((Number)this.timer.getProgress().getVideo()).doubleValue();
            this.log.v("transcode(): got progress, video=" + videoProgress + " audio=" + audioProgress);
            progress2.invoke((Object)((videoProgress + audioProgress) / (double)this.tracks.getActive().getSize()));
        }
        progress2.invoke((Object)1.0);
        this.dataSink.stop();
    }

    @Override
    public void cleanup() {
        Object object;
        Object $this$cleanup_u24lambda_u245;
        Object $this$cleanup_u24lambda_u244;
        Object $this$cleanup_u24lambda_u243;
        DefaultTranscodeEngine defaultTranscodeEngine = this;
        try {
            $this$cleanup_u24lambda_u243 = defaultTranscodeEngine;
            boolean bl = false;
            ((DefaultTranscodeEngine)$this$cleanup_u24lambda_u243).segments.release();
            $this$cleanup_u24lambda_u243 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$cleanup_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        defaultTranscodeEngine = this;
        try {
            $this$cleanup_u24lambda_u244 = defaultTranscodeEngine;
            boolean bl = false;
            ((DefaultTranscodeEngine)$this$cleanup_u24lambda_u244).dataSink.release();
            $this$cleanup_u24lambda_u244 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$cleanup_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        defaultTranscodeEngine = this;
        try {
            $this$cleanup_u24lambda_u245 = defaultTranscodeEngine;
            boolean bl = false;
            ((DefaultTranscodeEngine)$this$cleanup_u24lambda_u245).dataSources.release();
            $this$cleanup_u24lambda_u245 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$cleanup_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        defaultTranscodeEngine = this;
        try {
            DefaultTranscodeEngine $this$cleanup_u24lambda_u246 = defaultTranscodeEngine;
            boolean bl = false;
            $this$cleanup_u24lambda_u246.codecs.release();
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private static final double[] _init_$lambda$0(DataSource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getLocation();
    }

    private static final boolean createPipeline$lambda$1(DefaultTranscodeEngine this$0, TrackType $type) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$type), (String)"$type");
        return ((Number)this$0.timer.getPositionUs().get($type)).longValue() > this$0.timer.getTotalDurationUs() + 100L;
    }

    private static final boolean createPipeline$lambda$2(int $index, List $sources) {
        Intrinsics.checkNotNullParameter((Object)$sources, (String)"$sources");
        return $index < CollectionsKt.getLastIndex((List)$sources);
    }

    public static final /* synthetic */ Pipeline access$createPipeline(DefaultTranscodeEngine $this, TrackType type, int index, int count, TrackStatus status, MediaFormat outputFormat) {
        return $this.createPipeline(type, index, count, status, outputFormat);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/otaliastudios/transcoder/internal/transcode/DefaultTranscodeEngine$Companion;", "", "<init>", "()V", "WAIT_MS", "", "PROGRESS_LOOPS", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackStatus.values().length];
            try {
                nArray[TrackStatus.ABSENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackStatus.REMOVING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackStatus.PASS_THROUGH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackStatus.COMPRESSING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

