/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.pipeline;

import android.media.MediaFormat;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.Codecs;
import com.otaliastudios.transcoder.internal.audio.AudioEngine;
import com.otaliastudios.transcoder.internal.codec.Decoder;
import com.otaliastudios.transcoder.internal.codec.DecoderTimer;
import com.otaliastudios.transcoder.internal.codec.Encoder;
import com.otaliastudios.transcoder.internal.data.Bridge;
import com.otaliastudios.transcoder.internal.data.Reader;
import com.otaliastudios.transcoder.internal.data.ReaderTimer;
import com.otaliastudios.transcoder.internal.data.Writer;
import com.otaliastudios.transcoder.internal.pipeline.Pipeline;
import com.otaliastudios.transcoder.internal.pipeline.PipelineKt;
import com.otaliastudios.transcoder.internal.pipeline.Step;
import com.otaliastudios.transcoder.internal.video.VideoPublisher;
import com.otaliastudios.transcoder.internal.video.VideoRenderer;
import com.otaliastudios.transcoder.resample.AudioResampler;
import com.otaliastudios.transcoder.sink.DataSink;
import com.otaliastudios.transcoder.source.DataSource;
import com.otaliastudios.transcoder.stretch.AudioStretcher;
import com.otaliastudios.transcoder.time.TimeInterpolator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a(\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001aZ\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001aB\u0010\u0018\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001aJ\u0010\u0019\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u001a"}, d2={"EmptyPipeline", "Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline;", "PassThroughPipeline", "track", "Lcom/otaliastudios/transcoder/common/TrackType;", "source", "Lcom/otaliastudios/transcoder/source/DataSource;", "sink", "Lcom/otaliastudios/transcoder/sink/DataSink;", "interpolator", "Lcom/otaliastudios/transcoder/time/TimeInterpolator;", "RegularPipeline", "debug", "", "format", "Landroid/media/MediaFormat;", "codecs", "Lcom/otaliastudios/transcoder/internal/Codecs;", "videoRotation", "", "audioStretcher", "Lcom/otaliastudios/transcoder/stretch/AudioStretcher;", "audioResampler", "Lcom/otaliastudios/transcoder/resample/AudioResampler;", "VideoPipeline", "AudioPipeline", "lib_release"})
public final class PipelinesKt {
    @NotNull
    public static final Pipeline EmptyPipeline() {
        return Pipeline.Companion.build$lib_release$default(Pipeline.Companion, "Empty", null, null, 6, null);
    }

    @NotNull
    public static final Pipeline PassThroughPipeline(@NotNull TrackType track, @NotNull DataSource source, @NotNull DataSink sink, @NotNull TimeInterpolator interpolator) {
        Intrinsics.checkNotNullParameter((Object)((Object)track), (String)"track");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        return Pipeline.Companion.build$lib_release$default(Pipeline.Companion, "PassThrough" + track, null, () -> PipelinesKt.PassThroughPipeline$lambda$0(source, track, interpolator, sink), 2, null);
    }

    @NotNull
    public static final Pipeline RegularPipeline(@NotNull TrackType track, @Nullable String debug, @NotNull DataSource source, @NotNull DataSink sink, @NotNull TimeInterpolator interpolator, @NotNull MediaFormat format, @NotNull Codecs codecs, int videoRotation, @NotNull AudioStretcher audioStretcher, @NotNull AudioResampler audioResampler) {
        Intrinsics.checkNotNullParameter((Object)((Object)track), (String)"track");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)codecs, (String)"codecs");
        Intrinsics.checkNotNullParameter((Object)audioStretcher, (String)"audioStretcher");
        Intrinsics.checkNotNullParameter((Object)audioResampler, (String)"audioResampler");
        return switch (WhenMappings.$EnumSwitchMapping$0[track.ordinal()]) {
            case 1 -> PipelinesKt.VideoPipeline(debug, source, sink, interpolator, format, codecs, videoRotation);
            case 2 -> PipelinesKt.AudioPipeline(debug, source, sink, interpolator, format, codecs, audioStretcher, audioResampler);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Pipeline VideoPipeline(String debug, DataSource source, DataSink sink, TimeInterpolator interpolator, MediaFormat format, Codecs codecs, int videoRotation) {
        return Pipeline.Companion.build$lib_release("Video", debug, () -> PipelinesKt.VideoPipeline$lambda$1(source, interpolator, videoRotation, format, codecs, sink));
    }

    private static final Pipeline AudioPipeline(String debug, DataSource source, DataSink sink, TimeInterpolator interpolator, MediaFormat format, Codecs codecs, AudioStretcher audioStretcher, AudioResampler audioResampler) {
        return Pipeline.Companion.build$lib_release("Audio", debug, () -> PipelinesKt.AudioPipeline$lambda$2(source, interpolator, audioStretcher, audioResampler, format, codecs, sink));
    }

    private static final Pipeline.Builder PassThroughPipeline$lambda$0(DataSource $source, TrackType $track, TimeInterpolator $interpolator, DataSink $sink) {
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        Intrinsics.checkNotNullParameter((Object)((Object)$track), (String)"$track");
        Intrinsics.checkNotNullParameter((Object)$interpolator, (String)"$interpolator");
        Intrinsics.checkNotNullParameter((Object)$sink, (String)"$sink");
        Pipeline.Builder builder = PipelineKt.plus(new Reader($source, $track), new ReaderTimer($track, $interpolator));
        MediaFormat mediaFormat = $source.getTrackFormat($track);
        Intrinsics.checkNotNull((Object)mediaFormat);
        return builder.plus(new Bridge(mediaFormat)).plus(new Writer($sink, $track));
    }

    private static final Pipeline.Builder VideoPipeline$lambda$1(DataSource $source, TimeInterpolator $interpolator, int $videoRotation, MediaFormat $format, Codecs $codecs, DataSink $sink) {
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        Intrinsics.checkNotNullParameter((Object)$interpolator, (String)"$interpolator");
        Intrinsics.checkNotNullParameter((Object)$format, (String)"$format");
        Intrinsics.checkNotNullParameter((Object)$codecs, (String)"$codecs");
        Intrinsics.checkNotNullParameter((Object)$sink, (String)"$sink");
        Step step = new Reader($source, TrackType.VIDEO);
        MediaFormat mediaFormat = $source.getTrackFormat(TrackType.VIDEO);
        Intrinsics.checkNotNull((Object)mediaFormat);
        return PipelineKt.plus(step, new Decoder(mediaFormat, true)).plus(new DecoderTimer(TrackType.VIDEO, $interpolator)).plus(new VideoRenderer($source.getOrientation(), $videoRotation, $format, false, 8, null)).plus(new VideoPublisher()).plus(new Encoder($codecs, TrackType.VIDEO)).plus(new Writer($sink, TrackType.VIDEO));
    }

    private static final Pipeline.Builder AudioPipeline$lambda$2(DataSource $source, TimeInterpolator $interpolator, AudioStretcher $audioStretcher, AudioResampler $audioResampler, MediaFormat $format, Codecs $codecs, DataSink $sink) {
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        Intrinsics.checkNotNullParameter((Object)$interpolator, (String)"$interpolator");
        Intrinsics.checkNotNullParameter((Object)$audioStretcher, (String)"$audioStretcher");
        Intrinsics.checkNotNullParameter((Object)$audioResampler, (String)"$audioResampler");
        Intrinsics.checkNotNullParameter((Object)$format, (String)"$format");
        Intrinsics.checkNotNullParameter((Object)$codecs, (String)"$codecs");
        Intrinsics.checkNotNullParameter((Object)$sink, (String)"$sink");
        Step step = new Reader($source, TrackType.AUDIO);
        MediaFormat mediaFormat = $source.getTrackFormat(TrackType.AUDIO);
        Intrinsics.checkNotNull((Object)mediaFormat);
        return PipelineKt.plus(step, new Decoder(mediaFormat, true)).plus(new DecoderTimer(TrackType.AUDIO, $interpolator)).plus(new AudioEngine($audioStretcher, $audioResampler, $format)).plus(new Encoder($codecs, TrackType.AUDIO)).plus(new Writer($sink, TrackType.AUDIO));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackType.values().length];
            try {
                nArray[TrackType.VIDEO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackType.AUDIO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

