/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.data;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.data.WriterChannel;
import com.otaliastudios.transcoder.internal.data.WriterData;
import com.otaliastudios.transcoder.internal.pipeline.BaseStep;
import com.otaliastudios.transcoder.internal.pipeline.Channel;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.sink.DataSink;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/otaliastudios/transcoder/internal/data/Writer;", "Lcom/otaliastudios/transcoder/internal/pipeline/BaseStep;", "Lcom/otaliastudios/transcoder/internal/data/WriterData;", "Lcom/otaliastudios/transcoder/internal/data/WriterChannel;", "", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel;", "sink", "Lcom/otaliastudios/transcoder/sink/DataSink;", "track", "Lcom/otaliastudios/transcoder/common/TrackType;", "<init>", "(Lcom/otaliastudios/transcoder/sink/DataSink;Lcom/otaliastudios/transcoder/common/TrackType;)V", "channel", "getChannel", "()Lcom/otaliastudios/transcoder/internal/data/Writer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "handleFormat", "format", "Landroid/media/MediaFormat;", "advance", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "state", "Lcom/otaliastudios/transcoder/internal/pipeline/State$Ok;", "lib_release"})
public final class Writer
extends BaseStep<WriterData, WriterChannel, Unit, Channel>
implements WriterChannel {
    @NotNull
    private final DataSink sink;
    @NotNull
    private final TrackType track;
    @NotNull
    private final Writer channel;
    @NotNull
    private final MediaCodec.BufferInfo info;

    public Writer(@NotNull DataSink sink, @NotNull TrackType track) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)((Object)track), (String)"track");
        super("Writer");
        this.sink = sink;
        this.track = track;
        this.channel = this;
        this.info = new MediaCodec.BufferInfo();
    }

    @Override
    @NotNull
    public Writer getChannel() {
        return this.channel;
    }

    @Override
    public void handleFormat(@NotNull MediaFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.getLog().i("handleFormat(" + format + ")");
        this.sink.setTrackFormat(this.track, format);
    }

    @Override
    @NotNull
    public State<Unit> advance(@NotNull State.Ok<WriterData> state) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        WriterData writerData = state.getValue();
        ByteBuffer buffer = writerData.component1();
        long timestamp = writerData.component2();
        int flags = writerData.component3();
        boolean eos = state instanceof State.Eos;
        if (eos) {
            this.info.set(0, 0, 0L, flags | 4);
        } else {
            this.info.set(buffer.position(), buffer.remaining(), timestamp, flags);
        }
        this.sink.writeTrack(this.track, buffer, this.info);
        state.getValue().getRelease().invoke();
        return eos ? (State)new State.Eos<Unit>(Unit.INSTANCE) : (State)new State.Ok<Unit>(Unit.INSTANCE);
    }
}

