/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.data;

import com.otaliastudios.transcoder.internal.pipeline.BaseStep;
import com.otaliastudios.transcoder.internal.pipeline.Channel;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.source.DataSource;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/otaliastudios/transcoder/internal/data/Seeker;", "Lcom/otaliastudios/transcoder/internal/pipeline/BaseStep;", "", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel;", "source", "Lcom/otaliastudios/transcoder/source/DataSource;", "positions", "", "", "seek", "Lkotlin/Function1;", "", "<init>", "(Lcom/otaliastudios/transcoder/source/DataSource;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "channel", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel$Companion;", "getChannel", "()Lcom/otaliastudios/transcoder/internal/pipeline/Channel$Companion;", "", "advance", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "state", "Lcom/otaliastudios/transcoder/internal/pipeline/State$Ok;", "lib_release"})
public final class Seeker
extends BaseStep<Unit, Channel, Unit, Channel> {
    @NotNull
    private final DataSource source;
    @NotNull
    private final Function1<Long, Boolean> seek;
    @NotNull
    private final Channel.Companion channel;
    @NotNull
    private final List<Long> positions;

    public Seeker(@NotNull DataSource source, @NotNull List<Long> positions, @NotNull Function1<? super Long, Boolean> seek) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(positions, (String)"positions");
        Intrinsics.checkNotNullParameter(seek, (String)"seek");
        super("Seeker");
        this.source = source;
        this.seek = seek;
        this.channel = Channel.Companion;
        this.positions = CollectionsKt.toMutableList((Collection)positions);
    }

    @Override
    @NotNull
    public Channel.Companion getChannel() {
        return this.channel;
    }

    @Override
    @NotNull
    public State<Unit> advance(@NotNull State.Ok<Unit> state) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        if (!((Collection)this.positions).isEmpty() && ((Boolean)this.seek.invoke(CollectionsKt.first(this.positions))).booleanValue()) {
            this.getLog().i("Seeking to next position " + CollectionsKt.first(this.positions));
            long next = ((Number)CollectionsKt.removeFirst(this.positions)).longValue();
            this.source.seekTo(next);
        }
        return state;
    }
}

