/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.data;

import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.data.ReaderChannel;
import com.otaliastudios.transcoder.internal.data.ReaderData;
import com.otaliastudios.transcoder.internal.pipeline.BaseStep;
import com.otaliastudios.transcoder.internal.pipeline.Channel;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.source.DataSource;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ/\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u001e\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00130\u0015H\u0082\bJ\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/otaliastudios/transcoder/internal/data/Reader;", "Lcom/otaliastudios/transcoder/internal/pipeline/BaseStep;", "", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel;", "Lcom/otaliastudios/transcoder/internal/data/ReaderData;", "Lcom/otaliastudios/transcoder/internal/data/ReaderChannel;", "source", "Lcom/otaliastudios/transcoder/source/DataSource;", "track", "Lcom/otaliastudios/transcoder/common/TrackType;", "<init>", "(Lcom/otaliastudios/transcoder/source/DataSource;Lcom/otaliastudios/transcoder/common/TrackType;)V", "channel", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel$Companion;", "getChannel", "()Lcom/otaliastudios/transcoder/internal/pipeline/Channel$Companion;", "chunk", "Lcom/otaliastudios/transcoder/source/DataSource$Chunk;", "nextBufferOrWait", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "action", "Lkotlin/Function2;", "Ljava/nio/ByteBuffer;", "", "advance", "state", "Lcom/otaliastudios/transcoder/internal/pipeline/State$Ok;", "lib_release"})
@SourceDebugExtension(value={"SMAP\nReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Reader.kt\ncom/otaliastudios/transcoder/internal/data/Reader\n*L\n1#1,59:1\n26#1,7:60\n26#1,7:67\n*S KotlinDebug\n*F\n+ 1 Reader.kt\ncom/otaliastudios/transcoder/internal/data/Reader\n*L\n39#1:60,7\n50#1:67,7\n*E\n"})
public final class Reader
extends BaseStep<Unit, Channel, ReaderData, ReaderChannel> {
    @NotNull
    private final DataSource source;
    @NotNull
    private final TrackType track;
    @NotNull
    private final Channel.Companion channel;
    @NotNull
    private final DataSource.Chunk chunk;

    public Reader(@NotNull DataSource source, @NotNull TrackType track) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)track), (String)"track");
        super("Reader");
        this.source = source;
        this.track = track;
        this.channel = Channel.Companion;
        this.chunk = new DataSource.Chunk();
    }

    @Override
    @NotNull
    public Channel.Companion getChannel() {
        return this.channel;
    }

    private final State<ReaderData> nextBufferOrWait(Function2<? super ByteBuffer, ? super Integer, ? extends State<ReaderData>> action) {
        boolean $i$f$nextBufferOrWait = false;
        Pair<ByteBuffer, Integer> buffer = ((ReaderChannel)this.getNext()).buffer();
        if (buffer == null) {
            this.getLog().v("Returning State.Wait because buffer is null.");
            return new State.Retry(true);
        }
        return (State)action.invoke(buffer.getFirst(), buffer.getSecond());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public State<ReaderData> advance(@NotNull State.Ok<Unit> state) {
        State state2;
        Intrinsics.checkNotNullParameter(state, (String)"state");
        if (this.source.isDrained()) {
            this.getLog().i("Source is drained! Returning Eos as soon as possible.");
            Reader this_$iv = this;
            boolean $i$f$nextBufferOrWait = false;
            Pair<ByteBuffer, Integer> buffer$iv = ((ReaderChannel)this_$iv.getNext()).buffer();
            if (buffer$iv == null) {
                this_$iv.getLog().v("Returning State.Wait because buffer is null.");
                state2 = new State.Retry(true);
            } else {
                void id;
                int n = ((Number)buffer$iv.getSecond()).intValue();
                ByteBuffer byteBuffer = (ByteBuffer)buffer$iv.getFirst();
                boolean bl = false;
                byteBuffer.limit(0);
                this.chunk.buffer = byteBuffer;
                this.chunk.keyframe = false;
                this.chunk.render = true;
                state2 = new State.Eos<ReaderData>(new ReaderData(this.chunk, (int)id));
            }
        } else if (!this.source.canReadTrack(this.track)) {
            this.getLog().i("Returning State.Wait because source can't read " + this.track + " right now.");
            state2 = new State.Retry(false);
        } else {
            Reader this_$iv = this;
            boolean $i$f$nextBufferOrWait = false;
            Pair<ByteBuffer, Integer> buffer$iv = ((ReaderChannel)this_$iv.getNext()).buffer();
            if (buffer$iv == null) {
                this_$iv.getLog().v("Returning State.Wait because buffer is null.");
                state2 = new State.Retry(true);
            } else {
                int id = ((Number)buffer$iv.getSecond()).intValue();
                ByteBuffer byteBuffer = (ByteBuffer)buffer$iv.getFirst();
                boolean bl = false;
                this.chunk.buffer = byteBuffer;
                this.source.readTrack(this.chunk);
                state2 = new State.Ok<ReaderData>(new ReaderData(this.chunk, id));
            }
        }
        return state2;
    }
}

