/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.codec;

import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.codec.DecoderChannel;
import com.otaliastudios.transcoder.internal.codec.DecoderData;
import com.otaliastudios.transcoder.internal.codec.DecoderTimerData;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.internal.pipeline.TransformStep;
import com.otaliastudios.transcoder.time.TimeInterpolator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/otaliastudios/transcoder/internal/codec/DecoderTimer;", "Lcom/otaliastudios/transcoder/internal/pipeline/TransformStep;", "Lcom/otaliastudios/transcoder/internal/codec/DecoderData;", "Lcom/otaliastudios/transcoder/internal/codec/DecoderChannel;", "track", "Lcom/otaliastudios/transcoder/common/TrackType;", "interpolator", "Lcom/otaliastudios/transcoder/time/TimeInterpolator;", "<init>", "(Lcom/otaliastudios/transcoder/common/TrackType;Lcom/otaliastudios/transcoder/time/TimeInterpolator;)V", "lastTimeUs", "", "lastRawTimeUs", "advance", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "state", "Lcom/otaliastudios/transcoder/internal/pipeline/State$Ok;", "lib_release"})
public final class DecoderTimer
extends TransformStep<DecoderData, DecoderChannel> {
    @NotNull
    private final TrackType track;
    @NotNull
    private final TimeInterpolator interpolator;
    private long lastTimeUs;
    private long lastRawTimeUs;

    public DecoderTimer(@NotNull TrackType track, @NotNull TimeInterpolator interpolator) {
        Intrinsics.checkNotNullParameter((Object)((Object)track), (String)"track");
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        super("DecoderTimer");
        this.track = track;
        this.interpolator = interpolator;
        this.lastTimeUs = Long.MIN_VALUE;
        this.lastRawTimeUs = Long.MIN_VALUE;
    }

    @Override
    @NotNull
    public State<DecoderData> advance(@NotNull State.Ok<DecoderData> state) {
        double d;
        Intrinsics.checkNotNullParameter(state, (String)"state");
        if (state instanceof State.Eos) {
            return state;
        }
        if (!(!(state.getValue() instanceof DecoderTimerData))) {
            boolean bl = false;
            String string = "Can't apply DecoderTimer twice.";
            throw new IllegalArgumentException(string.toString());
        }
        long rawTimeUs = state.getValue().getTimeUs();
        long timeUs = this.interpolator.interpolate(this.track, rawTimeUs);
        if (this.lastTimeUs == Long.MIN_VALUE) {
            d = 1.0;
        } else {
            long durationUs2 = timeUs - this.lastTimeUs;
            long rawDurationUs = rawTimeUs - this.lastRawTimeUs;
            d = (double)durationUs2 / (double)rawDurationUs;
        }
        double timeStretch = d;
        this.lastTimeUs = timeUs;
        this.lastRawTimeUs = rawTimeUs;
        return new State.Ok<DecoderTimerData>(new DecoderTimerData(state.getValue().getBuffer(), rawTimeUs, timeUs, timeStretch, state.getValue().getRelease()));
    }
}

