/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.audio;

import android.media.MediaFormat;
import com.otaliastudios.transcoder.internal.audio.Chunk;
import com.otaliastudios.transcoder.internal.audio.ConversionsKt;
import com.otaliastudios.transcoder.internal.audio.ShortBufferPool;
import com.otaliastudios.transcoder.internal.utils.Logger;
import java.nio.ShortBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ,\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aJ\u0006\u0010\u001b\u001a\u00020\u0012Jn\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u0002H\u001d2K\u0010!\u001aG\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u0002H\u001d0\"\u00a2\u0006\u0002\u0010%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"Lcom/otaliastudios/transcoder/internal/audio/ChunkQueue;", "", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "<init>", "(Lcom/otaliastudios/transcoder/internal/utils/Logger;)V", "queue", "Lkotlin/collections/ArrayDeque;", "Lcom/otaliastudios/transcoder/internal/audio/Chunk;", "pool", "Lcom/otaliastudios/transcoder/internal/audio/ShortBufferPool;", "isEmpty", "", "size", "", "getSize", "()I", "enqueue", "", "buffer", "Ljava/nio/ShortBuffer;", "timeUs", "", "timeStretch", "", "release", "Lkotlin/Function0;", "enqueueEos", "drain", "T", "format", "Landroid/media/MediaFormat;", "eos", "action", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "(Landroid/media/MediaFormat;Ljava/lang/Object;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "lib_release"})
public final class ChunkQueue {
    @NotNull
    private final Logger log;
    @NotNull
    private final ArrayDeque<Chunk> queue;
    @NotNull
    private final ShortBufferPool pool;

    public ChunkQueue(@NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
        this.queue = new ArrayDeque();
        this.pool = new ShortBufferPool();
    }

    public final boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public final int getSize() {
        return this.queue.size();
    }

    public final void enqueue(@NotNull ShortBuffer buffer, long timeUs, double timeStretch, @NotNull Function0<Unit> release) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(release, (String)"release");
        if (buffer.hasRemaining()) {
            if (this.queue.size() >= 3) {
                ShortBuffer copy = this.pool.take(buffer);
                this.queue.addLast((Object)new Chunk(copy, timeUs, timeStretch, (Function0<Unit>)((Function0)() -> ChunkQueue.enqueue$lambda$0(this, copy))));
                release.invoke();
            } else {
                this.queue.addLast((Object)new Chunk(buffer, timeUs, timeStretch, release));
            }
        } else {
            this.log.w("enqueued invalid buffer (" + timeUs + ", " + buffer.capacity() + ")");
            release.invoke();
        }
    }

    public final void enqueueEos() {
        this.queue.addLast((Object)Chunk.Companion.getEos());
    }

    public final <T> T drain(@NotNull MediaFormat format, T eos, @NotNull Function3<? super ShortBuffer, ? super Long, ? super Double, ? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Chunk head = (Chunk)this.queue.removeFirst();
        if (head == Chunk.Companion.getEos()) {
            return eos;
        }
        int size = head.getBuffer().remaining();
        int limit = head.getBuffer().limit();
        Object result = action.invoke((Object)head.getBuffer(), (Object)head.getTimeUs(), (Object)head.getTimeStretch());
        head.getBuffer().limit(limit);
        if (head.getBuffer().hasRemaining()) {
            int consumed = size - head.getBuffer().remaining();
            int sampleRate = format.getInteger("sample-rate");
            int channelCount = format.getInteger("channel-count");
            ShortBuffer buffer = this.pool.take(head.getBuffer());
            head.getRelease().invoke();
            long l = ConversionsKt.shortsToUs(consumed, sampleRate, channelCount);
            this.queue.addFirst((Object)Chunk.copy$default(head, buffer, l, 0.0, () -> ChunkQueue.drain$lambda$1(this, buffer), 4, null));
            this.log.v("drain(): partially handled chunk at " + head.getTimeUs() + "us, " + head.getBuffer().remaining() + " bytes left (" + this.queue.size() + ")");
        } else {
            this.log.v("drain(): consumed chunk at " + head.getTimeUs() + "us (" + (this.queue.size() + 1) + " => " + this.queue.size() + ")");
            head.getRelease().invoke();
        }
        return (T)result;
    }

    private static final Unit enqueue$lambda$0(ChunkQueue this$0, ShortBuffer $copy) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$copy, (String)"$copy");
        this$0.pool.give($copy);
        return Unit.INSTANCE;
    }

    private static final Unit drain$lambda$1(ChunkQueue this$0, ShortBuffer $buffer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
        this$0.pool.give($buffer);
        return Unit.INSTANCE;
    }
}

