/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.audio;

import android.media.MediaFormat;
import android.view.Surface;
import com.otaliastudios.transcoder.internal.audio.ChunkQueue;
import com.otaliastudios.transcoder.internal.audio.ShortBuffers;
import com.otaliastudios.transcoder.internal.audio.remix.AudioRemixer;
import com.otaliastudios.transcoder.internal.codec.DecoderChannel;
import com.otaliastudios.transcoder.internal.codec.DecoderData;
import com.otaliastudios.transcoder.internal.codec.DecoderTimerData;
import com.otaliastudios.transcoder.internal.codec.EncoderChannel;
import com.otaliastudios.transcoder.internal.codec.EncoderData;
import com.otaliastudios.transcoder.internal.pipeline.QueuedStep;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.resample.AudioResampler;
import com.otaliastudios.transcoder.stretch.AudioStretcher;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u000bH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u000bH\u0016J\u0010\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0002H\u0014J\u0010\u0010'\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0002H\u0014J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040)H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u00020\u0014*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/otaliastudios/transcoder/internal/audio/AudioEngine;", "Lcom/otaliastudios/transcoder/internal/pipeline/QueuedStep;", "Lcom/otaliastudios/transcoder/internal/codec/DecoderData;", "Lcom/otaliastudios/transcoder/internal/codec/DecoderChannel;", "Lcom/otaliastudios/transcoder/internal/codec/EncoderData;", "Lcom/otaliastudios/transcoder/internal/codec/EncoderChannel;", "stretcher", "Lcom/otaliastudios/transcoder/stretch/AudioStretcher;", "resampler", "Lcom/otaliastudios/transcoder/resample/AudioResampler;", "targetFormat", "Landroid/media/MediaFormat;", "<init>", "(Lcom/otaliastudios/transcoder/stretch/AudioStretcher;Lcom/otaliastudios/transcoder/resample/AudioResampler;Landroid/media/MediaFormat;)V", "channel", "getChannel", "()Lcom/otaliastudios/transcoder/internal/audio/AudioEngine;", "buffers", "Lcom/otaliastudios/transcoder/internal/audio/ShortBuffers;", "sampleRate", "", "getSampleRate", "(Landroid/media/MediaFormat;)I", "channels", "getChannels", "chunks", "Lcom/otaliastudios/transcoder/internal/audio/ChunkQueue;", "readyToDrain", "", "rawFormat", "remixer", "Lcom/otaliastudios/transcoder/internal/audio/remix/AudioRemixer;", "handleSourceFormat", "Landroid/view/Surface;", "sourceFormat", "handleRawFormat", "", "enqueueEos", "data", "enqueue", "drain", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "lib_release"})
public final class AudioEngine
extends QueuedStep<DecoderData, DecoderChannel, EncoderData, EncoderChannel>
implements DecoderChannel {
    @NotNull
    private final AudioStretcher stretcher;
    @NotNull
    private final AudioResampler resampler;
    @NotNull
    private final MediaFormat targetFormat;
    @NotNull
    private final AudioEngine channel;
    @NotNull
    private final ShortBuffers buffers;
    @NotNull
    private final ChunkQueue chunks;
    private boolean readyToDrain;
    private MediaFormat rawFormat;
    private AudioRemixer remixer;

    public AudioEngine(@NotNull AudioStretcher stretcher, @NotNull AudioResampler resampler, @NotNull MediaFormat targetFormat) {
        Intrinsics.checkNotNullParameter((Object)stretcher, (String)"stretcher");
        Intrinsics.checkNotNullParameter((Object)resampler, (String)"resampler");
        Intrinsics.checkNotNullParameter((Object)targetFormat, (String)"targetFormat");
        super("AudioEngine");
        this.stretcher = stretcher;
        this.resampler = resampler;
        this.targetFormat = targetFormat;
        this.channel = this;
        this.buffers = new ShortBuffers();
        this.chunks = new ChunkQueue(this.getLog());
    }

    @Override
    @NotNull
    public AudioEngine getChannel() {
        return this.channel;
    }

    private final int getSampleRate(MediaFormat $this$sampleRate) {
        return $this$sampleRate.getInteger("sample-rate");
    }

    private final int getChannels(MediaFormat $this$channels) {
        return $this$channels.getInteger("channel-count");
    }

    @Override
    @Nullable
    public Surface handleSourceFormat(@NotNull MediaFormat sourceFormat) {
        Intrinsics.checkNotNullParameter((Object)sourceFormat, (String)"sourceFormat");
        return null;
    }

    @Override
    public void handleRawFormat(@NotNull MediaFormat rawFormat) {
        Intrinsics.checkNotNullParameter((Object)rawFormat, (String)"rawFormat");
        this.getLog().i("handleRawFormat(" + rawFormat + ")");
        this.rawFormat = rawFormat;
        this.remixer = AudioRemixer.Companion.get$lib_release(this.getChannels(rawFormat), this.getChannels(this.targetFormat));
        this.readyToDrain = true;
    }

    @Override
    protected void enqueueEos(@NotNull DecoderData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.getLog().i("enqueueEos (" + this.chunks.getSize() + " in queue)");
        data.getRelease().invoke((Object)false);
        this.chunks.enqueueEos();
    }

    @Override
    protected void enqueue(@NotNull DecoderData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DecoderTimerData decoderTimerData = data instanceof DecoderTimerData ? (DecoderTimerData)data : null;
        double stretch = decoderTimerData != null ? decoderTimerData.getTimeStretch() : 1.0;
        ShortBuffer shortBuffer = data.getBuffer().asShortBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)shortBuffer, (String)"asShortBuffer(...)");
        this.chunks.enqueue(shortBuffer, data.getTimeUs(), stretch, (Function0<Unit>)((Function0)() -> AudioEngine.enqueue$lambda$0(data)));
    }

    @Override
    @NotNull
    protected State<EncoderData> drain() {
        if (!this.readyToDrain) {
            this.getLog().i("drain(): not ready, waiting... (" + this.chunks.getSize() + " in queue)");
            return new State.Retry(false);
        }
        if (this.chunks.isEmpty()) {
            this.getLog().i("drain(): no chunks, waiting...");
            return new State.Retry(false);
        }
        Pair<ByteBuffer, Integer> pair = ((EncoderChannel)this.getNext()).buffer();
        if (pair == null) {
            AudioEngine $this$drain_u24lambda_u241 = this;
            boolean bl = false;
            $this$drain_u24lambda_u241.getLog().i("drain(): no next buffer, waiting... (" + $this$drain_u24lambda_u241.chunks.getSize() + " in queue)");
            return new State.Retry(true);
        }
        Pair<ByteBuffer, Integer> pair2 = pair;
        ByteBuffer outBytes = (ByteBuffer)pair2.component1();
        int outId = ((Number)pair2.component2()).intValue();
        ShortBuffer outBuffer = outBytes.asShortBuffer();
        ChunkQueue chunkQueue = this.chunks;
        State.Eos<EncoderData> eos = new State.Eos<EncoderData>(new EncoderData(outBytes, outId, 0L));
        MediaFormat mediaFormat = this.rawFormat;
        if (mediaFormat == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rawFormat");
            mediaFormat = null;
        }
        MediaFormat mediaFormat2 = mediaFormat;
        return chunkQueue.drain(mediaFormat2, eos, (arg_0, arg_1, arg_2) -> AudioEngine.drain$lambda$2(outBuffer, this, outBytes, outId, arg_0, arg_1, arg_2));
    }

    private static final Unit enqueue$lambda$0(DecoderData $data) {
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        $data.getRelease().invoke((Object)false);
        return Unit.INSTANCE;
    }

    private static final State.Ok drain$lambda$2(ShortBuffer $outBuffer, AudioEngine this$0, ByteBuffer $outBytes, int $outId, ShortBuffer inBuffer, long timeUs, double stretch) {
        int n;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$outBytes, (String)"$outBytes");
        Intrinsics.checkNotNullParameter((Object)inBuffer, (String)"inBuffer");
        int outSize = $outBuffer.remaining();
        int inSize = inBuffer.remaining();
        double desiredOutSize = Math.ceil((double)inSize * stretch);
        AudioRemixer audioRemixer = this$0.remixer;
        if (audioRemixer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remixer");
            audioRemixer = null;
        }
        desiredOutSize = audioRemixer.getRemixedSize((int)desiredOutSize);
        double d = desiredOutSize * (double)this$0.getSampleRate(this$0.targetFormat);
        MediaFormat mediaFormat = this$0.rawFormat;
        if (mediaFormat == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rawFormat");
            mediaFormat = null;
        }
        if ((desiredOutSize = Math.ceil(d / (double)this$0.getSampleRate(mediaFormat))) <= (double)outSize) {
            n = inSize;
        } else {
            double factor = desiredOutSize / (double)inSize;
            n = (int)Math.floor((double)outSize / factor);
        }
        int processableSize = n;
        inBuffer.limit(inBuffer.position() + processableSize);
        double stretchSize = Math.ceil((double)processableSize * stretch);
        ShortBuffer stretchBuffer = this$0.buffers.acquire("stretch", (int)stretchSize);
        AudioStretcher audioStretcher = this$0.stretcher;
        MediaFormat mediaFormat2 = this$0.rawFormat;
        if (mediaFormat2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rawFormat");
            mediaFormat2 = null;
        }
        audioStretcher.stretch(inBuffer, stretchBuffer, this$0.getChannels(mediaFormat2));
        stretchBuffer.flip();
        AudioRemixer audioRemixer2 = this$0.remixer;
        if (audioRemixer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remixer");
            audioRemixer2 = null;
        }
        int remixSize = audioRemixer2.getRemixedSize((int)stretchSize);
        ShortBuffer remixBuffer = this$0.buffers.acquire("remix", remixSize);
        AudioRemixer audioRemixer3 = this$0.remixer;
        if (audioRemixer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remixer");
            audioRemixer3 = null;
        }
        audioRemixer3.remix(stretchBuffer, remixBuffer);
        remixBuffer.flip();
        AudioResampler audioResampler = this$0.resampler;
        MediaFormat mediaFormat3 = this$0.rawFormat;
        if (mediaFormat3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rawFormat");
            mediaFormat3 = null;
        }
        audioResampler.resample(remixBuffer, this$0.getSampleRate(mediaFormat3), $outBuffer, this$0.getSampleRate(this$0.targetFormat), this$0.getChannels(this$0.targetFormat));
        $outBuffer.flip();
        $outBytes.clear();
        $outBytes.limit($outBuffer.limit() * 2);
        $outBytes.position($outBuffer.position() * 2);
        this$0.getLog().v("drain(): passing buffer " + $outId + " to encoder... " + this$0.chunks.getSize() + " in queue");
        return new State.Ok<EncoderData>(new EncoderData($outBytes, $outId, timeUs));
    }
}

