/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.transcoder.Transcoder;
import com.otaliastudios.transcoder.TranscoderListener;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.resample.AudioResampler;
import com.otaliastudios.transcoder.resample.DefaultAudioResampler;
import com.otaliastudios.transcoder.sink.DataSink;
import com.otaliastudios.transcoder.sink.DefaultDataSink;
import com.otaliastudios.transcoder.source.AssetFileDescriptorDataSource;
import com.otaliastudios.transcoder.source.DataSource;
import com.otaliastudios.transcoder.source.FileDescriptorDataSource;
import com.otaliastudios.transcoder.source.FilePathDataSource;
import com.otaliastudios.transcoder.source.UriDataSource;
import com.otaliastudios.transcoder.strategy.DefaultAudioStrategy;
import com.otaliastudios.transcoder.strategy.DefaultVideoStrategies;
import com.otaliastudios.transcoder.strategy.TrackStrategy;
import com.otaliastudios.transcoder.stretch.AudioStretcher;
import com.otaliastudios.transcoder.stretch.DefaultAudioStretcher;
import com.otaliastudios.transcoder.time.DefaultTimeInterpolator;
import com.otaliastudios.transcoder.time.SpeedTimeInterpolator;
import com.otaliastudios.transcoder.time.TimeInterpolator;
import com.otaliastudios.transcoder.validator.DefaultValidator;
import com.otaliastudios.transcoder.validator.Validator;
import java.io.FileDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

public class TranscoderOptions {
    private DataSink dataSink;
    private List<DataSource> videoDataSources;
    private List<DataSource> audioDataSources;
    private TrackStrategy audioTrackStrategy;
    private TrackStrategy videoTrackStrategy;
    private Validator validator;
    private int videoRotation;
    private TimeInterpolator timeInterpolator;
    private AudioStretcher audioStretcher;
    private AudioResampler audioResampler;
    private TranscoderListener listener;
    private Handler listenerHandler;

    private TranscoderOptions() {
    }

    @NonNull
    public TranscoderListener getListener() {
        return this.listener;
    }

    @NonNull
    public Handler getListenerHandler() {
        return this.listenerHandler;
    }

    @NonNull
    public DataSink getDataSink() {
        return this.dataSink;
    }

    @NonNull
    public List<DataSource> getAudioDataSources() {
        return this.audioDataSources;
    }

    @NonNull
    public List<DataSource> getVideoDataSources() {
        return this.videoDataSources;
    }

    @NonNull
    public TrackStrategy getAudioTrackStrategy() {
        return this.audioTrackStrategy;
    }

    @NonNull
    public TrackStrategy getVideoTrackStrategy() {
        return this.videoTrackStrategy;
    }

    @NonNull
    public Validator getValidator() {
        return this.validator;
    }

    public int getVideoRotation() {
        return this.videoRotation;
    }

    @NonNull
    public TimeInterpolator getTimeInterpolator() {
        return this.timeInterpolator;
    }

    @NonNull
    public AudioStretcher getAudioStretcher() {
        return this.audioStretcher;
    }

    @NonNull
    public AudioResampler getAudioResampler() {
        return this.audioResampler;
    }

    public static class Builder {
        private final DataSink dataSink;
        private final List<DataSource> audioDataSources = new ArrayList<DataSource>();
        private final List<DataSource> videoDataSources = new ArrayList<DataSource>();
        private TranscoderListener listener;
        private Handler listenerHandler;
        private TrackStrategy audioTrackStrategy;
        private TrackStrategy videoTrackStrategy;
        private Validator validator;
        private int videoRotation;
        private TimeInterpolator timeInterpolator;
        private AudioStretcher audioStretcher;
        private AudioResampler audioResampler;

        Builder(@NonNull String outPath) {
            this.dataSink = new DefaultDataSink(outPath);
        }

        @RequiresApi(api=26)
        Builder(@NonNull FileDescriptor fileDescriptor) {
            this.dataSink = new DefaultDataSink(fileDescriptor);
        }

        Builder(@NonNull DataSink dataSink) {
            this.dataSink = dataSink;
        }

        @NonNull
        public Builder addDataSource(@NonNull DataSource dataSource) {
            this.audioDataSources.add(dataSource);
            this.videoDataSources.add(dataSource);
            return this;
        }

        @NonNull
        public Builder addDataSource(@NonNull TrackType type, @NonNull DataSource dataSource) {
            if (type == TrackType.AUDIO) {
                this.audioDataSources.add(dataSource);
            } else if (type == TrackType.VIDEO) {
                this.videoDataSources.add(dataSource);
            }
            return this;
        }

        @NonNull
        public Builder addDataSource(@NonNull FileDescriptor fileDescriptor) {
            return this.addDataSource(new FileDescriptorDataSource(fileDescriptor));
        }

        @NonNull
        public Builder addDataSource(@NonNull TrackType type, @NonNull FileDescriptor fileDescriptor) {
            return this.addDataSource(type, new FileDescriptorDataSource(fileDescriptor));
        }

        @NonNull
        public Builder addDataSource(@NonNull AssetFileDescriptor assetFileDescriptor) {
            return this.addDataSource(new AssetFileDescriptorDataSource(assetFileDescriptor));
        }

        @NonNull
        public Builder addDataSource(@NonNull TrackType type, @NonNull AssetFileDescriptor assetFileDescriptor) {
            return this.addDataSource(type, new AssetFileDescriptorDataSource(assetFileDescriptor));
        }

        @NonNull
        public Builder addDataSource(@NonNull String inPath) {
            return this.addDataSource(new FilePathDataSource(inPath));
        }

        @NonNull
        public Builder addDataSource(@NonNull TrackType type, @NonNull String inPath) {
            return this.addDataSource(type, new FilePathDataSource(inPath));
        }

        @NonNull
        public Builder addDataSource(@NonNull Context context, @NonNull Uri uri) {
            return this.addDataSource(new UriDataSource(context, uri));
        }

        @NonNull
        public Builder addDataSource(@NonNull TrackType type, @NonNull Context context, @NonNull Uri uri) {
            return this.addDataSource(type, new UriDataSource(context, uri));
        }

        @NonNull
        public Builder setAudioTrackStrategy(@Nullable TrackStrategy trackStrategy) {
            this.audioTrackStrategy = trackStrategy;
            return this;
        }

        @NonNull
        public Builder setVideoTrackStrategy(@Nullable TrackStrategy trackStrategy) {
            this.videoTrackStrategy = trackStrategy;
            return this;
        }

        @NonNull
        public Builder setListener(@NonNull TranscoderListener listener) {
            this.listener = listener;
            return this;
        }

        @NonNull
        public Builder setListenerHandler(@Nullable Handler listenerHandler) {
            this.listenerHandler = listenerHandler;
            return this;
        }

        @NonNull
        public Builder setValidator(@Nullable Validator validator) {
            this.validator = validator;
            return this;
        }

        @NonNull
        public Builder setVideoRotation(int rotation) {
            this.videoRotation = rotation;
            return this;
        }

        @NonNull
        public Builder setTimeInterpolator(@NonNull TimeInterpolator timeInterpolator) {
            this.timeInterpolator = timeInterpolator;
            return this;
        }

        @NonNull
        public Builder setSpeed(float speedFactor) {
            return this.setTimeInterpolator(new SpeedTimeInterpolator(speedFactor));
        }

        @NonNull
        public Builder setAudioStretcher(@NonNull AudioStretcher audioStretcher) {
            this.audioStretcher = audioStretcher;
            return this;
        }

        @NonNull
        public Builder setAudioResampler(@NonNull AudioResampler audioResampler) {
            this.audioResampler = audioResampler;
            return this;
        }

        @NonNull
        public TranscoderOptions build() {
            if (this.listener == null) {
                throw new IllegalStateException("listener can't be null");
            }
            if (this.audioDataSources.isEmpty() && this.videoDataSources.isEmpty()) {
                throw new IllegalStateException("we need at least one data source");
            }
            if (this.videoRotation != 0 && this.videoRotation != 90 && this.videoRotation != 180 && this.videoRotation != 270) {
                throw new IllegalArgumentException("Accepted values for rotation are 0, 90, 180, 270");
            }
            if (this.listenerHandler == null) {
                Looper looper = Looper.myLooper();
                if (looper == null) {
                    looper = Looper.getMainLooper();
                }
                this.listenerHandler = new Handler(looper);
            }
            if (this.audioTrackStrategy == null) {
                this.audioTrackStrategy = DefaultAudioStrategy.builder().build();
            }
            if (this.videoTrackStrategy == null) {
                this.videoTrackStrategy = DefaultVideoStrategies.for720x1280();
            }
            if (this.validator == null) {
                this.validator = new DefaultValidator();
            }
            if (this.timeInterpolator == null) {
                this.timeInterpolator = new DefaultTimeInterpolator();
            }
            if (this.audioStretcher == null) {
                this.audioStretcher = new DefaultAudioStretcher();
            }
            if (this.audioResampler == null) {
                this.audioResampler = new DefaultAudioResampler();
            }
            TranscoderOptions options = new TranscoderOptions();
            options.listener = this.listener;
            options.audioDataSources = this.audioDataSources;
            options.videoDataSources = this.videoDataSources;
            options.dataSink = this.dataSink;
            options.listenerHandler = this.listenerHandler;
            options.audioTrackStrategy = this.audioTrackStrategy;
            options.videoTrackStrategy = this.videoTrackStrategy;
            options.validator = this.validator;
            options.videoRotation = this.videoRotation;
            options.timeInterpolator = this.timeInterpolator;
            options.audioStretcher = this.audioStretcher;
            options.audioResampler = this.audioResampler;
            return options;
        }

        @NonNull
        public Future<Void> transcode() {
            return Transcoder.getInstance().transcode(this.build());
        }
    }
}

