/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.engine;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.postgresql.PostgresConnector;
import io.debezium.embedded.EmbeddedEngineConfig;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.runtime.Connector;
import io.debezium.runtime.ConnectorProducer;
import io.debezium.runtime.Debezium;
import io.debezium.runtime.DebeziumConnectorRegistry;
import io.debezium.runtime.EngineManifest;
import io.debezium.runtime.configuration.DebeziumEngineConfiguration;
import io.debezium.runtime.configuration.QuarkusDatasourceConfiguration;
import io.quarkus.debezium.configuration.DebeziumConfigurationEngineParser;
import io.quarkus.debezium.engine.SourceRecordDebezium;
import io.quarkus.debezium.engine.StateHandler;
import io.quarkus.debezium.engine.capture.consumer.SourceRecordConsumerHandler;
import io.quarkus.debezium.notification.QuarkusNotificationChannel;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@ApplicationScoped
public class PostgresEngineProducer
implements ConnectorProducer {
    public static final Connector POSTGRES = new Connector(PostgresConnector.class.getName());
    public static final String DEBEZIUM_DATASOURCE_HOSTNAME = "database." + JdbcConfiguration.HOSTNAME.name();
    private final StateHandler stateHandler;
    private final Map<String, QuarkusDatasourceConfiguration> quarkusDatasourceConfigurations;
    private final QuarkusNotificationChannel channel;
    private final SourceRecordConsumerHandler sourceRecordConsumerHandler;
    private final DebeziumConfigurationEngineParser engineParser = new DebeziumConfigurationEngineParser();

    @Inject
    public PostgresEngineProducer(StateHandler stateHandler, Instance<QuarkusDatasourceConfiguration> configurations, QuarkusNotificationChannel channel, SourceRecordConsumerHandler sourceRecordConsumerHandler) {
        this.stateHandler = stateHandler;
        this.channel = channel;
        this.sourceRecordConsumerHandler = sourceRecordConsumerHandler;
        this.quarkusDatasourceConfigurations = configurations.stream().collect(Collectors.toMap(QuarkusDatasourceConfiguration::getSanitizedName, Function.identity()));
    }

    public PostgresEngineProducer(StateHandler stateHandler, Map<String, QuarkusDatasourceConfiguration> quarkusDatasourceConfigurations, QuarkusNotificationChannel channel, SourceRecordConsumerHandler sourceRecordConsumerHandler) {
        this.stateHandler = stateHandler;
        this.quarkusDatasourceConfigurations = quarkusDatasourceConfigurations;
        this.channel = channel;
        this.sourceRecordConsumerHandler = sourceRecordConsumerHandler;
    }

    @Produces
    @Singleton
    public DebeziumConnectorRegistry engine(DebeziumEngineConfiguration debeziumEngineConfiguration) {
        if (debeziumEngineConfiguration.defaultConfiguration().get(DEBEZIUM_DATASOURCE_HOSTNAME) != null) {
            return this.createRegistryFromLegacyConfiguration(debeziumEngineConfiguration.defaultConfiguration());
        }
        List multiEngineConfigurations = this.engineParser.parse(debeziumEngineConfiguration);
        final List<DebeziumConfigurationEngineParser.MultiEngineConfiguration> enrichedMultiEngineConfigurations = multiEngineConfigurations.stream().map(engine -> this.enrichConfiguration((DebeziumConfigurationEngineParser.MultiEngineConfiguration)engine, this.quarkusDatasourceConfigurations)).toList();
        return new DebeziumConnectorRegistry(){
            private final Map<String, Debezium> engines;
            {
                this.engines = enrichedMultiEngineConfigurations.stream().map(engine -> {
                    EngineManifest engineManifest = new EngineManifest(engine.engineId());
                    return Map.entry(engine.engineId(), new SourceRecordDebezium(engine.configuration(), PostgresEngineProducer.this.stateHandler, POSTGRES, PostgresEngineProducer.this.sourceRecordConsumerHandler.get(engineManifest), engineManifest));
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }

            public Connector connector() {
                return POSTGRES;
            }

            public Debezium get(EngineManifest manifest) {
                return this.engines.get(manifest.id());
            }

            public List<Debezium> engines() {
                return this.engines.values().stream().toList();
            }
        };
    }

    private DebeziumConfigurationEngineParser.MultiEngineConfiguration enrichConfiguration(DebeziumConfigurationEngineParser.MultiEngineConfiguration engine, Map<String, QuarkusDatasourceConfiguration> collect) {
        HashMap<String, String> mutableMap = new HashMap<String, String>(engine.configuration());
        mutableMap.compute(CommonConnectorConfig.NOTIFICATION_ENABLED_CHANNELS.name(), (key, value) -> value == null ? this.channel.name() : value.concat("," + this.channel.name()));
        mutableMap.putAll(this.getQuarkusDatasourceConfigurationByEngineId(engine.engineId(), collect).asDebezium());
        mutableMap.put(EmbeddedEngineConfig.CONNECTOR_CLASS.name(), POSTGRES.name());
        return new DebeziumConfigurationEngineParser.MultiEngineConfiguration(engine.engineId(), mutableMap);
    }

    private QuarkusDatasourceConfiguration getQuarkusDatasourceConfigurationByEngineId(String engineId, Map<String, QuarkusDatasourceConfiguration> collect) {
        QuarkusDatasourceConfiguration configuration = collect.get(engineId);
        if (configuration == null) {
            throw new IllegalArgumentException("No datasource configuration found for engine " + engineId);
        }
        return configuration;
    }

    private DebeziumConnectorRegistry createRegistryFromLegacyConfiguration(final Map<String, String> configuration) {
        configuration.compute(CommonConnectorConfig.NOTIFICATION_ENABLED_CHANNELS.name(), (key, value) -> value == null ? this.channel.name() : value.concat("," + this.channel.name()));
        configuration.put(EmbeddedEngineConfig.CONNECTOR_CLASS.name(), POSTGRES.name());
        return new DebeziumConnectorRegistry(){
            private final SourceRecordDebezium engine;
            {
                this.engine = new SourceRecordDebezium(configuration, PostgresEngineProducer.this.stateHandler, POSTGRES, PostgresEngineProducer.this.sourceRecordConsumerHandler.get(EngineManifest.DEFAULT), EngineManifest.DEFAULT);
            }

            public Connector connector() {
                return POSTGRES;
            }

            public Debezium get(EngineManifest manifest) {
                if (manifest == null || manifest.id() == null || !manifest.id().equals("default")) {
                    return null;
                }
                return this.engine;
            }

            public List<Debezium> engines() {
                return List.of(this.engine);
            }
        };
    }
}

