/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.configuration;

import io.debezium.jdbc.JdbcConfiguration;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourceParser {
    private static final Logger logger = LoggerFactory.getLogger(DatasourceParser.class);
    public static final String REGEX = "jdbc:[a-z]+://(?<hostname>[^:/;?]+)(:(?<port>\\d+))?([/;](?<dbname>[^?;]+))?";
    private static final Pattern pattern = Pattern.compile("jdbc:[a-z]+://(?<hostname>[^:/;?]+)(:(?<port>\\d+))?([/;](?<dbname>[^?;]+))?");
    private final String value;

    public DatasourceParser(String value) {
        this.value = value;
    }

    public Optional<JdbcDatasource> asString() {
        Matcher matcher = pattern.matcher(this.value);
        if (matcher.find()) {
            logger.trace("Found datasource definition for {}", (Object)this.value);
            String host = matcher.group(JdbcConfiguration.HOSTNAME.name());
            String port = matcher.group(JdbcConfiguration.PORT.name());
            String database = matcher.group(JdbcConfiguration.DATABASE.name());
            return Optional.of(new JdbcDatasource(host, port, database));
        }
        logger.warn("Unable to parse datasource: {}", (Object)this.value);
        return Optional.empty();
    }

    public record JdbcDatasource(String host, String port, String database) {
    }
}

