/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.sample.app.resources;

import io.quarkus.sample.app.events.SnapshotEventObserver;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@Path(value="/notifications")
@ApplicationScoped
public class SnapshotEventResource {
    private final SnapshotEventObserver snapshotEventObserver;

    public SnapshotEventResource(SnapshotEventObserver snapshotEventObserver) {
        this.snapshotEventObserver = snapshotEventObserver;
    }

    @GET
    @Produces(value={"application/json"})
    public Response notification(@QueryParam(value="engine") @DefaultValue(value="default") String engine) {
        if (this.snapshotEventObserver.getDefaultSnapshotEvents("default").isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(this.snapshotEventObserver.getDefaultSnapshotEvents(engine).stream().map(a -> a.getClass().getName())).build();
    }
}

