/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.sample.app.events;

import io.debezium.runtime.events.AbstractDebeziumLifecycleEvent;
import io.debezium.runtime.events.ConnectorStartedEvent;
import io.debezium.runtime.events.ConnectorStoppedEvent;
import io.debezium.runtime.events.DefaultEngine;
import io.debezium.runtime.events.Engine;
import io.debezium.runtime.events.PollingStartedEvent;
import io.debezium.runtime.events.PollingStoppedEvent;
import io.debezium.runtime.events.TasksStartedEvent;
import io.debezium.runtime.events.TasksStoppedEvent;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@ApplicationScoped
public class LifecycleEventObserver {
    private final List<AbstractDebeziumLifecycleEvent> defaultLifecycleEvents = new CopyOnWriteArrayList<AbstractDebeziumLifecycleEvent>();
    private final List<AbstractDebeziumLifecycleEvent> alternativeLifecycleEvents = new CopyOnWriteArrayList<AbstractDebeziumLifecycleEvent>();

    void defaultOnConnectorStarted(@Observes @Engine(value="default") ConnectorStartedEvent connectorStartedEvent) {
        this.defaultLifecycleEvents.add((AbstractDebeziumLifecycleEvent)connectorStartedEvent);
    }

    void defaultOnConnectorStopped(@Observes @Engine(value="default") ConnectorStoppedEvent connectorStoppedEvent) {
        this.defaultLifecycleEvents.add((AbstractDebeziumLifecycleEvent)connectorStoppedEvent);
    }

    void defaultOnTaskStarted(@Observes @DefaultEngine TasksStartedEvent tasksStartedEvent) {
        this.defaultLifecycleEvents.add((AbstractDebeziumLifecycleEvent)tasksStartedEvent);
    }

    void defaultOnTaskStopped(@Observes @Engine(value="default") TasksStoppedEvent tasksStoppedEvent) {
        this.defaultLifecycleEvents.add((AbstractDebeziumLifecycleEvent)tasksStoppedEvent);
    }

    void defaultOnPollingStarted(@Observes @Engine(value="default") PollingStartedEvent pollingStartedEvent) {
        this.defaultLifecycleEvents.add((AbstractDebeziumLifecycleEvent)pollingStartedEvent);
    }

    void defaultOnPollingStopped(@Observes @Engine(value="default") PollingStoppedEvent pollingStoppedEvent) {
        this.defaultLifecycleEvents.add((AbstractDebeziumLifecycleEvent)pollingStoppedEvent);
    }

    void alternativeOnConnectorStarted(@Observes @Engine(value="alternative") ConnectorStartedEvent connectorStartedEvent) {
        this.alternativeLifecycleEvents.add((AbstractDebeziumLifecycleEvent)connectorStartedEvent);
    }

    void alternativeOnConnectorStopped(@Observes @Engine(value="alternative") ConnectorStoppedEvent connectorStoppedEvent) {
        this.alternativeLifecycleEvents.add((AbstractDebeziumLifecycleEvent)connectorStoppedEvent);
    }

    void alternativeOnTaskStarted(@Observes @Engine(value="alternative") TasksStartedEvent tasksStartedEvent) {
        this.alternativeLifecycleEvents.add((AbstractDebeziumLifecycleEvent)tasksStartedEvent);
    }

    void alternativeOnTaskStopped(@Observes @Engine(value="alternative") TasksStoppedEvent tasksStoppedEvent) {
        this.alternativeLifecycleEvents.add((AbstractDebeziumLifecycleEvent)tasksStoppedEvent);
    }

    void alternativeOnPollingStarted(@Observes @Engine(value="alternative") PollingStartedEvent pollingStartedEvent) {
        this.alternativeLifecycleEvents.add((AbstractDebeziumLifecycleEvent)pollingStartedEvent);
    }

    void alternativeOnPollingStopped(@Observes @Engine(value="alternative") PollingStoppedEvent pollingStoppedEvent) {
        this.alternativeLifecycleEvents.add((AbstractDebeziumLifecycleEvent)pollingStoppedEvent);
    }

    public List<AbstractDebeziumLifecycleEvent> getLifecycleEvents(String engine) {
        if (engine.equals("default")) {
            return this.defaultLifecycleEvents;
        }
        return this.alternativeLifecycleEvents;
    }
}

