/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.notification;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.pipeline.notification.Notification;
import io.debezium.pipeline.notification.channels.NotificationChannel;
import io.quarkus.debezium.notification.NotificationHandler;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;

@ApplicationScoped
public class QuarkusNotificationChannel
implements NotificationChannel {
    private final Instance<NotificationHandler> notificationHandlers;

    public QuarkusNotificationChannel() {
        this.notificationHandlers = CDI.current().select(NotificationHandler.class, new Annotation[0]);
    }

    public QuarkusNotificationChannel(Instance<NotificationHandler> notificationHandlers) {
        this.notificationHandlers = notificationHandlers;
    }

    public void init(CommonConnectorConfig config) {
    }

    public String name() {
        return "quarkus";
    }

    public void send(Notification notification) {
        this.notificationHandlers.stream().filter(handler -> handler.isAvailable(notification.getAggregateType())).forEach(handler -> handler.handle(notification));
    }

    public void close() {
    }
}

