/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.heartbeat;

import io.debezium.heartbeat.Heartbeat;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.runtime.Debezium;
import io.debezium.runtime.events.DebeziumHeartbeat;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import java.util.Map;

@ApplicationScoped
public class QuarkusHeartbeatEmitter
implements Heartbeat {
    private final Debezium debezium;
    private final Event<DebeziumHeartbeat> heartbeat;

    @Inject
    public QuarkusHeartbeatEmitter(Debezium debezium, Event<DebeziumHeartbeat> heartbeat) {
        this.debezium = debezium;
        this.heartbeat = heartbeat;
    }

    public void emit(Map<String, ?> partition, OffsetContext offset) {
        this.heartbeat.fire((Object)new DebeziumHeartbeat(this.debezium.connector(), this.debezium.status(), partition, offset.getOffset()));
    }

    public boolean isEnabled() {
        return true;
    }
}

