/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.engine.relational.converter;

import io.debezium.converters.custom.CustomConverterFactory;
import io.debezium.relational.CustomConverterRegistry;
import io.debezium.spi.converter.ConvertedField;
import io.debezium.spi.converter.CustomConverter;
import io.quarkus.debezium.engine.relational.converter.QuarkusCustomConverter;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.connect.data.SchemaBuilder;

public class QuarkusCustomConverterFactory
implements CustomConverterFactory {
    private final List<QuarkusCustomConverter> converters;

    public QuarkusCustomConverterFactory() {
        this.converters = CDI.current().select(QuarkusCustomConverter.class, new Annotation[0]).stream().toList();
    }

    public QuarkusCustomConverterFactory(List<QuarkusCustomConverter> converters) {
        this.converters = converters;
    }

    public CustomConverter<SchemaBuilder, ConvertedField> get() {
        return new CustomConverter<SchemaBuilder, ConvertedField>(){

            public void configure(Properties props) {
            }

            public void converterFor(ConvertedField field, CustomConverter.ConverterRegistration<SchemaBuilder> registration) {
                QuarkusCustomConverterFactory.this.converters.forEach(converter -> {
                    if (!converter.filter(field)) {
                        return;
                    }
                    CustomConverterRegistry.ConverterDefinition<SchemaBuilder> definition = converter.bind(field);
                    registration.register((Object)((SchemaBuilder)definition.fieldSchema), definition.converter);
                });
            }
        };
    }
}

