/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.engine.deserializer;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.quarkus.debezium.engine.deserializer.Deserializer;
import io.quarkus.debezium.engine.deserializer.ObjectMapperProducer;
import java.io.IOException;

public class ObjectMapperDeserializer<T>
implements Deserializer<T> {
    public static final String PAYLOAD = "payload";
    private final JavaType type;
    private final ObjectMapper objectMapper;

    public ObjectMapperDeserializer(Class<T> type) {
        this(type, ObjectMapperProducer.get());
    }

    public ObjectMapperDeserializer(Class<T> type, ObjectMapper objectMapper) {
        this.type = TypeFactory.defaultInstance().constructType(type);
        this.objectMapper = objectMapper;
    }

    @Override
    public T deserialize(byte[] data, String path) {
        if (data == null) {
            return null;
        }
        if (path == null) {
            return this.deserializeFlattenEvent(data);
        }
        return this.deserializeDebeziumEvent(data, path);
    }

    private T deserializeFlattenEvent(byte[] data) {
        try {
            JsonNode root = this.objectMapper.readTree(data);
            return (T)this.objectMapper.treeToValue((TreeNode)root.path(PAYLOAD), this.type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private T deserializeDebeziumEvent(byte[] data, String path) {
        try {
            JsonNode root = this.objectMapper.readTree(data);
            JsonNode afterNode = root.path(PAYLOAD).path(path);
            return (T)this.objectMapper.treeToValue((TreeNode)afterNode, this.type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
    }
}

