/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.engine.deserializer;

import io.debezium.runtime.configuration.DebeziumEngineConfiguration;
import io.quarkus.debezium.engine.CapturingEventDeserializer;
import io.quarkus.debezium.engine.SourceRecordDeserializer;
import io.quarkus.debezium.engine.deserializer.CapturingEventDeserializerRegistry;
import io.quarkus.debezium.engine.deserializer.Deserializer;
import io.quarkus.debezium.engine.deserializer.MutableCapturingEventDeserializerRegistry;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.storage.Converter;

public class CapturingEventDeserializerRegistryProducer {
    private final JsonConverter converter = new JsonConverter();

    @Produces
    @Singleton
    public CapturingEventDeserializerRegistry<SourceRecord> produce(final DebeziumEngineConfiguration configuration) {
        return new MutableCapturingEventDeserializerRegistry<SourceRecord>(){
            private final Map<String, CapturingEventDeserializer<?, SourceRecord>> registry;
            {
                this.registry = configuration.capturing().values().stream().filter(config -> config.deserializer().isPresent() && config.destination().isPresent()).collect(Collectors.toMap(config -> (String)config.destination().get(), config -> CapturingEventDeserializerRegistryProducer.this.getDeserializer((String)config.deserializer().get())));
            }

            @Override
            public void register(String identifier, Deserializer<?> deserializer) {
                this.registry.put(identifier, new SourceRecordDeserializer(deserializer, (Converter)CapturingEventDeserializerRegistryProducer.this.converter));
            }

            @Override
            public void unregister(String identifier) {
                this.registry.remove(identifier);
            }

            @Override
            public CapturingEventDeserializer<?, SourceRecord> get(String identifier) {
                return this.registry.get(identifier);
            }
        };
    }

    private CapturingEventDeserializer<?, SourceRecord> getDeserializer(String deserializer) {
        try {
            return new SourceRecordDeserializer((Deserializer)Class.forName(deserializer, true, Thread.currentThread().getContextClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), (Converter)this.converter);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

