/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.engine.capture.consumer;

import io.debezium.engine.ChangeEvent;
import io.debezium.runtime.CapturingEvent;
import io.quarkus.debezium.engine.CapturingEventDeserializer;
import io.quarkus.debezium.engine.OperationMapper;
import io.quarkus.debezium.engine.capture.CapturingInvoker;
import io.quarkus.debezium.engine.capture.CapturingInvokerRegistry;
import io.quarkus.debezium.engine.capture.consumer.SourceRecordEventConsumer;
import io.quarkus.debezium.engine.deserializer.CapturingEventDeserializerRegistry;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceRecordEventProducer {
    private final CapturingInvokerRegistry<CapturingEvent<?>> capturingEventRegistry;
    private final CapturingInvokerRegistry<Object> capturingObjectInvokerRegistry;
    private final CapturingEventDeserializerRegistry<SourceRecord> capturingEventDeserializerRegistry;

    @Inject
    public SourceRecordEventProducer(CapturingInvokerRegistry<CapturingEvent<?>> capturingEventRegistry, CapturingEventDeserializerRegistry<SourceRecord> capturingEventDeserializerRegistry, CapturingInvokerRegistry<Object> capturingObjectInvokerRegistry) {
        this.capturingEventRegistry = capturingEventRegistry;
        this.capturingEventDeserializerRegistry = capturingEventDeserializerRegistry;
        this.capturingObjectInvokerRegistry = capturingObjectInvokerRegistry;
    }

    @Produces
    @Singleton
    public SourceRecordEventConsumer produce() {
        return new SourceRecordEventConsumer(){
            private final Logger logger = LoggerFactory.getLogger(SourceRecordEventConsumer.class);

            @Override
            public void accept(ChangeEvent<SourceRecord, SourceRecord> event) {
                CapturingEvent<SourceRecord> capturingEvent = OperationMapper.from(event);
                CapturingEventDeserializer<?, SourceRecord> deserializer = SourceRecordEventProducer.this.capturingEventDeserializerRegistry.get(capturingEvent.destination());
                CapturingInvoker<Object> objectCapturingInvoker = SourceRecordEventProducer.this.capturingObjectInvokerRegistry.get(capturingEvent.destination());
                if (deserializer != null && objectCapturingInvoker != null) {
                    objectCapturingInvoker.capture(deserializer.deserialize(capturingEvent).record());
                    return;
                }
                CapturingInvoker<CapturingEvent<?>> invoker = SourceRecordEventProducer.this.capturingEventRegistry.get(capturingEvent.destination());
                if (invoker == null) {
                    this.logger.debug("method annotated with @Capturing not found for destination: {}", (Object)capturingEvent.destination());
                    return;
                }
                if (deserializer != null) {
                    invoker.capture(deserializer.deserialize(capturingEvent));
                    return;
                }
                invoker.capture(capturingEvent);
            }
        };
    }
}

