/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.engine.capture;

import io.quarkus.debezium.engine.capture.CapturingInvoker;
import java.util.Collections;
import java.util.List;

class CapturingInvokerValidator<T extends CapturingInvoker<?>> {
    CapturingInvokerValidator() {
    }

    void validate(List<T> invokers) {
        List<String> destinations = invokers.stream().map(CapturingInvoker::destination).toList();
        invokers.forEach(invoker -> {
            if (Collections.frequency(destinations, invoker.destination()) > 1) {
                throw new IllegalArgumentException("Two or more methods are annotated with @Capturing and have the same destination " + invoker.destination());
            }
        });
    }
}

