/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.engine;

import io.debezium.data.Envelope;
import io.debezium.runtime.CapturingEvent;
import io.quarkus.debezium.engine.CapturingEventDeserializer;
import io.quarkus.debezium.engine.deserializer.Deserializer;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.storage.Converter;

public class SourceRecordDeserializer<T>
implements CapturingEventDeserializer<T, SourceRecord> {
    private final Deserializer<T> deserializer;
    private final Converter converter;

    public SourceRecordDeserializer(Deserializer<T> deserializer, Converter converter) {
        this.deserializer = deserializer;
        this.converter = converter;
        this.converter.configure(Map.of("schemas.enable", true), false);
    }

    @Override
    public CapturingEvent<T> deserialize(CapturingEvent<SourceRecord> event) {
        byte[] data = this.converter.fromConnectData(((SourceRecord)event.record()).topic(), ((SourceRecord)event.record()).valueSchema(), ((SourceRecord)event.record()).value());
        if (!Envelope.isEnvelopeSchema((Schema)((SourceRecord)event.record()).valueSchema())) {
            return new CapturingEvent.Message(this.deserializer.deserialize(data, null), event.destination(), event.source(), event.headers());
        }
        CapturingEvent<SourceRecord> capturingEvent = event;
        Objects.requireNonNull(capturingEvent);
        CapturingEvent<SourceRecord> capturingEvent2 = capturingEvent;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CapturingEvent.Create.class, CapturingEvent.Delete.class, CapturingEvent.Message.class, CapturingEvent.Read.class, CapturingEvent.Truncate.class, CapturingEvent.Update.class}, capturingEvent2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                CapturingEvent.Create record = (CapturingEvent.Create)capturingEvent2;
                yield new CapturingEvent.Create(this.deserializer.deserialize(data, "after"), record.destination(), record.source(), record.headers());
            }
            case 1 -> {
                CapturingEvent.Delete record = (CapturingEvent.Delete)capturingEvent2;
                yield new CapturingEvent.Delete(this.deserializer.deserialize(data, "before"), record.destination(), record.source(), record.headers());
            }
            case 2 -> {
                CapturingEvent.Message record = (CapturingEvent.Message)capturingEvent2;
                yield new CapturingEvent.Message(this.deserializer.deserialize(data, "after"), record.destination(), record.source(), record.headers());
            }
            case 3 -> {
                CapturingEvent.Read record = (CapturingEvent.Read)capturingEvent2;
                yield new CapturingEvent.Read(this.deserializer.deserialize(data, "after"), record.destination(), record.source(), record.headers());
            }
            case 4 -> {
                CapturingEvent.Truncate record = (CapturingEvent.Truncate)capturingEvent2;
                yield new CapturingEvent.Truncate(this.deserializer.deserialize(data, "after"), record.destination(), record.source(), record.headers());
            }
            case 5 -> {
                CapturingEvent.Update record = (CapturingEvent.Update)capturingEvent2;
                yield new CapturingEvent.Update(this.deserializer.deserialize(data, "after"), record.destination(), record.source(), record.headers());
            }
        };
    }
}

