/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.engine;

import io.debezium.data.Envelope;
import io.debezium.engine.ChangeEvent;
import io.debezium.runtime.CapturingEvent;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;

public class OperationMapper {
    public static final String NOT_AVAILABLE = "NOT_AVAILABLE";

    public static CapturingEvent<SourceRecord> from(ChangeEvent<SourceRecord, SourceRecord> record) {
        Struct payload = (Struct)((SourceRecord)record.value()).value();
        if (payload == null) {
            return new CapturingEvent.Message((Object)((SourceRecord)record.value()), record.destination(), NOT_AVAILABLE, record.headers());
        }
        if (payload.schema() == null) {
            return new CapturingEvent.Message((Object)((SourceRecord)record.value()), record.destination(), NOT_AVAILABLE, record.headers());
        }
        if (payload.schema().field("op") == null) {
            return new CapturingEvent.Message((Object)((SourceRecord)record.value()), record.destination(), NOT_AVAILABLE, record.headers());
        }
        return switch (Envelope.Operation.forCode((String)payload.getString("op"))) {
            default -> throw new MatchException(null, null);
            case Envelope.Operation.READ -> new CapturingEvent.Read((Object)((SourceRecord)record.value()), record.destination(), NOT_AVAILABLE, record.headers());
            case Envelope.Operation.CREATE -> new CapturingEvent.Create((Object)((SourceRecord)record.value()), record.destination(), NOT_AVAILABLE, record.headers());
            case Envelope.Operation.UPDATE -> new CapturingEvent.Update((Object)((SourceRecord)record.value()), record.destination(), NOT_AVAILABLE, record.headers());
            case Envelope.Operation.DELETE -> new CapturingEvent.Delete((Object)((SourceRecord)record.value()), record.destination(), NOT_AVAILABLE, record.headers());
            case Envelope.Operation.TRUNCATE -> new CapturingEvent.Truncate((Object)((SourceRecord)record.value()), record.destination(), NOT_AVAILABLE, record.headers());
            case Envelope.Operation.MESSAGE -> new CapturingEvent.Message((Object)((SourceRecord)record.value()), record.destination(), NOT_AVAILABLE, record.headers());
        };
    }
}

