/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.engine;

import io.debezium.runtime.Debezium;
import io.quarkus.debezium.engine.RunnableDebezium;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DebeziumRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebeziumRunner.class);
    private final ExecutorService executorService;
    private final RunnableDebezium engine;

    DebeziumRunner(ExecutorService executorService, Debezium debezium) {
        this.executorService = executorService;
        this.engine = (RunnableDebezium)debezium;
    }

    public void start() {
        LOGGER.info("Starting Debezium Engine...");
        this.executorService.execute(this.engine::run);
    }

    public void shutdown() {
        LOGGER.info("Shutting down Debezium Engine...");
        try {
            this.engine.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Impossible to shutdown Debezium Engine ", e);
        }
        finally {
            this.executorService.shutdown();
        }
    }
}

