/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.notification;

import io.debezium.pipeline.notification.Notification;
import io.debezium.pipeline.notification.SnapshotStatus;
import io.debezium.pipeline.spi.SnapshotResult;
import io.quarkus.debezium.notification.NotificationHandler;
import io.quarkus.debezium.notification.SnapshotAborted;
import io.quarkus.debezium.notification.SnapshotCompleted;
import io.quarkus.debezium.notification.SnapshotEvent;
import io.quarkus.debezium.notification.SnapshotInProgress;
import io.quarkus.debezium.notification.SnapshotPaused;
import io.quarkus.debezium.notification.SnapshotResumed;
import io.quarkus.debezium.notification.SnapshotSkipped;
import io.quarkus.debezium.notification.SnapshotStarted;
import io.quarkus.debezium.notification.SnapshotTableScanCompleted;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

@ApplicationScoped
public class SnapshotHandler
implements NotificationHandler {
    public static final BiConsumer<SnapshotEvent.Kind, Notification> NO_EVENT = (a, b) -> {};
    private static final List<String> kinds = Arrays.stream(SnapshotEvent.Kind.values()).map(SnapshotEvent.Kind::getDescription).toList();
    private final Map<String, BiConsumer<SnapshotEvent.Kind, Notification>> events = Map.of(SnapshotStatus.STARTED.name(), (kind, notification) -> startedEvent.fire((Object)new SnapshotStarted(notification.getId(), notification.getAdditionalData(), notification.getTimestamp(), (SnapshotEvent.Kind)((Object)kind))), SnapshotStatus.IN_PROGRESS.name(), (kind, notification) -> inProgressEvent.fire((Object)new SnapshotInProgress(notification.getId(), notification.getAdditionalData(), notification.getTimestamp(), (SnapshotEvent.Kind)((Object)kind))), SnapshotStatus.TABLE_SCAN_COMPLETED.name(), (kind, notification) -> tableScanCompletedEvent.fire((Object)new SnapshotTableScanCompleted(notification.getId(), notification.getAdditionalData(), notification.getTimestamp(), (SnapshotEvent.Kind)((Object)kind))), SnapshotStatus.COMPLETED.name(), (kind, notification) -> completedEvent.fire((Object)new SnapshotCompleted(notification.getId(), notification.getAdditionalData(), notification.getTimestamp(), (SnapshotEvent.Kind)((Object)kind))), SnapshotStatus.ABORTED.name(), (kind, notification) -> abortedEvent.fire((Object)new SnapshotAborted(notification.getId(), notification.getAdditionalData(), notification.getTimestamp(), (SnapshotEvent.Kind)((Object)kind))), SnapshotResult.SnapshotResultStatus.SKIPPED.name(), (kind, notification) -> skippedEvent.fire((Object)new SnapshotSkipped(notification.getId(), notification.getAdditionalData(), notification.getTimestamp(), (SnapshotEvent.Kind)((Object)kind))), SnapshotStatus.PAUSED.name(), (kind, notification) -> snapshotPausedEvent.fire((Object)new SnapshotPaused(notification.getId(), notification.getAdditionalData(), notification.getTimestamp(), (SnapshotEvent.Kind)((Object)kind))), SnapshotStatus.RESUMED.name(), (kind, notification) -> snapshotResumedEvent.fire((Object)new SnapshotResumed(notification.getId(), notification.getAdditionalData(), notification.getTimestamp(), (SnapshotEvent.Kind)((Object)kind))));

    @Inject
    public SnapshotHandler(Event<SnapshotStarted> startedEvent, Event<SnapshotInProgress> inProgressEvent, Event<SnapshotTableScanCompleted> tableScanCompletedEvent, Event<SnapshotCompleted> completedEvent, Event<SnapshotAborted> abortedEvent, Event<SnapshotSkipped> skippedEvent, Event<SnapshotPaused> snapshotPausedEvent, Event<SnapshotResumed> snapshotResumedEvent) {
    }

    @Override
    public boolean isAvailable(String aggregateType) {
        return kinds.contains(aggregateType);
    }

    @Override
    public void handle(Notification notification) {
        SnapshotEvent.Kind.from(notification.getAggregateType()).ifPresent(kind -> this.events.getOrDefault(notification.getType(), NO_EVENT).accept((SnapshotEvent.Kind)((Object)kind), notification));
    }
}

