/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.engine;

import io.debezium.config.Configuration;
import io.debezium.embedded.Connect;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.RecordChangeEvent;
import io.debezium.engine.format.ChangeEventFormat;
import io.debezium.runtime.Connector;
import io.debezium.runtime.DebeziumStatus;
import io.quarkus.debezium.engine.RunnableDebezium;
import io.quarkus.debezium.engine.StateHandler;
import io.quarkus.debezium.engine.capture.CapturingInvokerRegistry;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.connect.source.SourceRecord;

@ApplicationScoped
class SourceRecordDebezium
extends RunnableDebezium {
    private final Map<String, String> configuration;
    private final DebeziumEngine<?> engine;
    private final Connector connector;
    private final StateHandler stateHandler;

    SourceRecordDebezium(Map<String, String> configuration, StateHandler stateHandler, Connector connector, CapturingInvokerRegistry<RecordChangeEvent<SourceRecord>> registry) {
        this.configuration = configuration;
        this.stateHandler = stateHandler;
        this.engine = DebeziumEngine.create((ChangeEventFormat)ChangeEventFormat.of(Connect.class)).using(((Configuration.Builder)Configuration.empty().withSystemProperties(Function.identity()).edit().with(Configuration.from(configuration))).build().asProperties()).using(this.stateHandler.connectorCallback()).using(this.stateHandler.completionCallback()).notifying(event -> registry.get((RecordChangeEvent<SourceRecord>)event).capture((RecordChangeEvent)event)).build();
        this.stateHandler.setDebeziumEngine(this);
        this.connector = connector;
    }

    public DebeziumEngine.Signaler signaler() {
        return this.engine.getSignaler();
    }

    public Map<String, String> configuration() {
        return this.configuration;
    }

    public DebeziumStatus status() {
        return this.stateHandler.get();
    }

    public Connector connector() {
        return this.connector;
    }

    @Override
    protected void run() {
        this.engine.run();
    }

    @Override
    protected void close() throws IOException {
        this.engine.close();
    }
}

