/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.engine;

import io.debezium.engine.DebeziumEngine;
import io.debezium.runtime.Debezium;
import io.debezium.runtime.DebeziumStatus;
import io.debezium.runtime.events.ConnectorStartedEvent;
import io.debezium.runtime.events.ConnectorStoppedEvent;
import io.debezium.runtime.events.DebeziumCompletionEvent;
import io.debezium.runtime.events.PollingStartedEvent;
import io.debezium.runtime.events.PollingStoppedEvent;
import io.debezium.runtime.events.TasksStartedEvent;
import io.debezium.runtime.events.TasksStoppedEvent;
import io.quarkus.arc.Unremovable;
import io.quarkus.debezium.engine.StateHandler;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import java.util.concurrent.atomic.AtomicReference;

@ApplicationScoped
@Unremovable
public class DefaultStateHandler
implements StateHandler {
    private final AtomicReference<DebeziumStatus> status = new AtomicReference<DebeziumStatus>(new DebeziumStatus(DebeziumStatus.State.STOPPED));
    @Inject
    Event<ConnectorStartedEvent> connectorStarted;
    @Inject
    Event<ConnectorStoppedEvent> connectorStopped;
    @Inject
    Event<TasksStartedEvent> taskStarted;
    @Inject
    Event<TasksStoppedEvent> taskStopped;
    @Inject
    Event<PollingStartedEvent> pollingStarted;
    @Inject
    Event<PollingStoppedEvent> pollingStopped;
    @Inject
    Event<DebeziumCompletionEvent> completed;
    private Debezium engine;

    @Override
    public DebeziumEngine.ConnectorCallback connectorCallback() {
        return new DebeziumEngine.ConnectorCallback(){

            public void connectorStarted() {
                this.changeState(DebeziumStatus.State.CREATING);
                DefaultStateHandler.this.connectorStarted.fire((Object)new ConnectorStartedEvent(DefaultStateHandler.this.engine));
            }

            public void connectorStopped() {
                this.changeState(DebeziumStatus.State.STOPPED);
                DefaultStateHandler.this.connectorStopped.fire((Object)new ConnectorStoppedEvent(DefaultStateHandler.this.engine));
            }

            public void taskStarted() {
                DefaultStateHandler.this.taskStarted.fire((Object)new TasksStartedEvent(DefaultStateHandler.this.engine));
            }

            public void taskStopped() {
                DefaultStateHandler.this.taskStopped.fire((Object)new TasksStoppedEvent(DefaultStateHandler.this.engine));
            }

            public void pollingStarted() {
                this.changeState(DebeziumStatus.State.POLLING);
                DefaultStateHandler.this.pollingStarted.fire((Object)new PollingStartedEvent(DefaultStateHandler.this.engine));
            }

            public void pollingStopped() {
                DefaultStateHandler.this.pollingStopped.fire((Object)new PollingStoppedEvent(DefaultStateHandler.this.engine));
            }

            private void changeState(DebeziumStatus.State newState) {
                DefaultStateHandler.this.status.set(new DebeziumStatus(newState));
            }
        };
    }

    @Override
    public DebeziumEngine.CompletionCallback completionCallback() {
        return (success, message, error) -> {
            this.status.set(new DebeziumStatus(DebeziumStatus.State.STOPPED));
            this.completed.fire((Object)new DebeziumCompletionEvent(success, message, error));
        };
    }

    @Override
    public DebeziumStatus get() {
        return this.status.get();
    }

    @Override
    public void setDebeziumEngine(Debezium engine) {
        this.engine = engine;
    }
}

