/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.notification;

import io.quarkus.debezium.notification.Notification;
import io.quarkus.debezium.notification.SnapshotAborted;
import io.quarkus.debezium.notification.SnapshotCompleted;
import io.quarkus.debezium.notification.SnapshotInProgress;
import io.quarkus.debezium.notification.SnapshotPaused;
import io.quarkus.debezium.notification.SnapshotResumed;
import io.quarkus.debezium.notification.SnapshotSkipped;
import io.quarkus.debezium.notification.SnapshotStarted;
import io.quarkus.debezium.notification.SnapshotTableScanCompleted;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract sealed class SnapshotEvent
implements Notification
permits SnapshotStarted, SnapshotInProgress, SnapshotTableScanCompleted, SnapshotAborted, SnapshotSkipped, SnapshotCompleted, SnapshotPaused, SnapshotResumed {
    private final String id;
    private final Map<String, String> additionalData;
    private final Long timestamp;
    private final Kind kind;

    protected SnapshotEvent(String id, Map<String, String> additionalData, Long timestamp, Kind kind) {
        this.id = id;
        this.additionalData = additionalData;
        this.timestamp = timestamp;
        this.kind = kind;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Kind getKind() {
        return this.kind;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotEvent that = (SnapshotEvent)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.additionalData, that.additionalData) && Objects.equals(this.timestamp, that.timestamp) && this.kind == that.kind;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.additionalData, this.timestamp, this.kind});
    }

    public static enum Kind {
        INCREMENTAL("Incremental Snapshot"),
        INITIAL("Initial Snapshot");

        private final String description;

        private Kind(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public static Optional<Kind> from(String value) {
            return Arrays.stream(Kind.values()).filter(kind -> kind.getDescription().equals(value)).findFirst();
        }
    }
}

