/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.deployment.engine;

import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.debezium.deployment.engine.CapturingInvokerGenerator;
import io.quarkus.debezium.deployment.engine.GeneratedClassMetaData;
import java.util.Arrays;
import java.util.List;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;

public class MultipleCapturingInvokerGenerators
implements CapturingInvokerGenerator {
    private final CapturingInvokerGenerator defaultGenerator;
    private final List<CapturingInvokerGenerator> generators;

    public MultipleCapturingInvokerGenerators(CapturingInvokerGenerator defaultGenerator, CapturingInvokerGenerator ... generators) {
        this.defaultGenerator = defaultGenerator;
        this.generators = Arrays.stream(generators).toList();
    }

    @Override
    public GeneratedClassMetaData generate(MethodInfo methodInfo, BeanInfo beanInfo) {
        return this.generators.stream().filter(generator -> generator.isCompatible(((MethodParameterInfo)methodInfo.parameters().getFirst()).type())).findFirst().map(generator -> generator.generate(methodInfo, beanInfo)).orElseGet(() -> this.defaultGenerator.generate(methodInfo, beanInfo));
    }
}

