/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.deployment.engine;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.embedded.EmbeddedEngineConfig;
import io.debezium.embedded.async.ConvertingAsyncEngineBuilderFactory;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.spi.OffsetCommitPolicy;
import io.debezium.pipeline.notification.channels.LogNotificationChannel;
import io.debezium.pipeline.notification.channels.SinkNotificationChannel;
import io.debezium.pipeline.notification.channels.jmx.JmxNotificationChannel;
import io.debezium.pipeline.signal.actions.StandardActionProvider;
import io.debezium.pipeline.signal.channels.FileSignalChannel;
import io.debezium.pipeline.signal.channels.KafkaSignalChannel;
import io.debezium.pipeline.signal.channels.SourceSignalChannel;
import io.debezium.pipeline.signal.channels.jmx.JmxSignalChannel;
import io.debezium.pipeline.signal.channels.process.InProcessSignalChannel;
import io.debezium.pipeline.txmetadata.DefaultTransactionMetadataFactory;
import io.debezium.processors.spi.PostProcessor;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.runtime.FieldFilterStrategy;
import io.debezium.runtime.configuration.DebeziumEngineConfiguration;
import io.debezium.runtime.events.DefaultEngine;
import io.debezium.runtime.events.Engine;
import io.debezium.schema.SchemaTopicNamingStrategy;
import io.debezium.snapshot.lock.NoLockingSupport;
import io.debezium.snapshot.mode.AlwaysSnapshotter;
import io.debezium.snapshot.mode.ConfigurationBasedSnapshotter;
import io.debezium.snapshot.mode.InitialOnlySnapshotter;
import io.debezium.snapshot.mode.InitialSnapshotter;
import io.debezium.snapshot.mode.NeverSnapshotter;
import io.debezium.snapshot.mode.NoDataSnapshotter;
import io.debezium.snapshot.mode.RecoverySnapshotter;
import io.debezium.snapshot.mode.WhenNeededSnapshotter;
import io.debezium.snapshot.spi.SnapshotLock;
import io.debezium.transforms.ExtractNewRecordState;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.debezium.deployment.dotnames.DebeziumDotNames;
import io.quarkus.debezium.deployment.engine.CapturingEventGenerator;
import io.quarkus.debezium.deployment.engine.CapturingObjectInvokerGenerator;
import io.quarkus.debezium.deployment.engine.ClassesInConfigurationHandler;
import io.quarkus.debezium.deployment.engine.CustomConverterGenerator;
import io.quarkus.debezium.deployment.engine.GeneratedClassMetaData;
import io.quarkus.debezium.deployment.engine.GeneratedConverterClassMetaData;
import io.quarkus.debezium.deployment.engine.MultipleCapturingInvokerGenerators;
import io.quarkus.debezium.deployment.engine.PostProcessorGenerator;
import io.quarkus.debezium.deployment.items.DebeziumConnectorBuildItem;
import io.quarkus.debezium.deployment.items.DebeziumExtensionNameBuildItem;
import io.quarkus.debezium.deployment.items.DebeziumGeneratedCustomConverterBuildItem;
import io.quarkus.debezium.deployment.items.DebeziumGeneratedInvokerBuildItem;
import io.quarkus.debezium.deployment.items.DebeziumGeneratedPostProcessorBuildItem;
import io.quarkus.debezium.deployment.items.DebeziumMediatorBuildItem;
import io.quarkus.debezium.engine.DebeziumRecorder;
import io.quarkus.debezium.engine.DefaultStateHandler;
import io.quarkus.debezium.engine.capture.CapturingEventInvokerRegistryProducer;
import io.quarkus.debezium.engine.capture.CapturingObjectInvokerRegistryProducer;
import io.quarkus.debezium.engine.capture.DynamicCapturingInvokerSupplier;
import io.quarkus.debezium.engine.capture.consumer.SourceRecordEventProducer;
import io.quarkus.debezium.engine.converter.custom.DynamicCustomConverterSupplier;
import io.quarkus.debezium.engine.deserializer.CapturingEventDeserializerRegistryProducer;
import io.quarkus.debezium.engine.deserializer.ObjectMapperDeserializer;
import io.quarkus.debezium.engine.post.processing.ArcPostProcessorFactory;
import io.quarkus.debezium.engine.post.processing.DynamicPostProcessingSupplier;
import io.quarkus.debezium.engine.relational.converter.QuarkusCustomConverter;
import io.quarkus.debezium.heartbeat.ArcHeartbeatFactory;
import io.quarkus.debezium.heartbeat.QuarkusHeartbeatEmitter;
import io.quarkus.debezium.notification.DefaultNotificationHandler;
import io.quarkus.debezium.notification.QuarkusNotificationChannel;
import io.quarkus.debezium.notification.SnapshotHandler;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.runtime.ShutdownContext;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.common.security.authenticator.SaslClientAuthenticator;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.source.SourceTask;
import org.apache.kafka.connect.transforms.predicates.TopicNameMatches;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class EngineProcessor {
    public static final List<String> PROPERTIES_WITH_CLASSES = List.of(HistorizedRelationalDatabaseConnectorConfig.SCHEMA_HISTORY.name(), CommonConnectorConfig.TOPIC_NAMING_STRATEGY.name(), EmbeddedEngineConfig.OFFSET_STORAGE.name());

    @BuildStep
    void features(BuildProducer<FeatureBuildItem> producer, List<DebeziumExtensionNameBuildItem> debeziumExtensionNameBuildItems) {
        debeziumExtensionNameBuildItems.forEach(item -> producer.produce((BuildItem)new FeatureBuildItem("debezium-" + item.getName())));
    }

    @BuildStep
    AutoInjectAnnotationBuildItem autoInjectEngine() {
        return new AutoInjectAnnotationBuildItem(new DotName[]{DotName.createSimple(Engine.class)});
    }

    @BuildStep
    void engine(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, List<DebeziumConnectorBuildItem> debeziumConnectorBuildItems) {
        debeziumConnectorBuildItems.forEach(item -> additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{item.producer()}).setUnremovable().setDefaultScope(DotNames.APPLICATION_SCOPED).build()));
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(Engine.class));
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(DefaultEngine.class));
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{CapturingEventDeserializerRegistryProducer.class}).setDefaultScope(DotNames.APPLICATION_SCOPED).setUnremovable().build());
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{CapturingEventInvokerRegistryProducer.class, CapturingObjectInvokerRegistryProducer.class}).setDefaultScope(DotNames.APPLICATION_SCOPED).setUnremovable().build());
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{SourceRecordEventProducer.class}).setDefaultScope(DotNames.APPLICATION_SCOPED).setUnremovable().build());
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{DefaultStateHandler.class}).build());
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{DefaultNotificationHandler.class, SnapshotHandler.class, QuarkusNotificationChannel.class, QuarkusHeartbeatEmitter.class}).setUnremovable().build());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void startEngine(BeanContainerBuildItem beanContainerBuildItem, DebeziumRecorder recorder, ShutdownContextBuildItem shutdownContextBuildItem) {
        recorder.startEngine((ShutdownContext)shutdownContextBuildItem, beanContainerBuildItem.getValue());
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    NativeImageConfigBuildItem nativeImageConfiguration() {
        return NativeImageConfigBuildItem.builder().addRuntimeInitializedClass("org.apache.kafka.common.security.authenticator.SaslClientAuthenticator").build();
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void registerNativeImageResources(BuildProducer<NativeImageResourceBuildItem> resources) {
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.embedded.async.ConvertingAsyncEngineBuilderFactory"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.engine.DebeziumEngine$BuilderFactory"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.snapshot.spi.SnapshotLock"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.snapshot.spi.SnapshotQuery"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.spi.snapshot.Snapshotter"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.spi.snapshot.Snapshotter"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.apache.kafka.connect.source.SourceConnector"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.pipeline.signal.channels.SignalChannelReader"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.pipeline.notification.channels.NotificationChannel"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.processors.PostProcessorProducer"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.heartbeat.DebeziumHeartbeatFactory"}));
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void registerClassesThatAreLoadedThroughReflection(CombinedIndexBuildItem indexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, DebeziumEngineConfiguration debeziumEngineConfiguration) {
        List<String> classesAnnotatedWithInjectService = DebeziumDotNames.ANNOTATED_WITH_INJECT_SERVICE.stream().map(DotName::toString).toList();
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classesAnnotatedWithInjectService.toArray(new String[0])).reason(DebeziumDotNames.DEBEZIUM_ENGINE_PROCESSOR.toString()).constructors(false).methods().build());
        ClassesInConfigurationHandler.TRANSFORM.extract(debeziumEngineConfiguration.defaultConfiguration()).forEach(transform -> reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{transform}).reason(this.getClass().getName()).build()));
        ClassesInConfigurationHandler.PREDICATE.extract(debeziumEngineConfiguration.defaultConfiguration()).forEach(predicate -> reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{predicate}).reason(this.getClass().getName()).build()));
        debeziumEngineConfiguration.defaultConfiguration().entrySet().stream().filter(property -> PROPERTIES_WITH_CLASSES.contains(property.getKey())).forEach(item -> reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{(String)item.getValue()}).reason(this.getClass().getName()).constructors(true).methods(true).fields(true).build()));
        debeziumEngineConfiguration.capturing().values().stream().flatMap(capturing -> capturing.configurations().entrySet().stream()).filter(property -> PROPERTIES_WITH_CLASSES.contains(property.getKey())).forEach(item -> reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{(String)item.getValue()}).reason(this.getClass().getName()).constructors(true).methods(true).fields(true).build()));
        ClassesInConfigurationHandler.POST_PROCESSOR.extract(debeziumEngineConfiguration.defaultConfiguration()).forEach(postProcessor -> reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{postProcessor}).reason(this.getClass().getName()).build()));
        this.extractClassToDeserialize(indexBuildItem).forEach(clazz -> reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{clazz.asClassType().toString()}).reason(this.getClass().getName()).constructors(true).methods(true).fields(true).build()));
        this.extractDeserializers(debeziumEngineConfiguration).forEach(deserializer -> reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{deserializer}).reason(this.getClass().getName()).build()));
        debeziumEngineConfiguration.capturing().values().stream().flatMap(capturing -> capturing.deserializers().values().stream()).map(DebeziumEngineConfiguration.DeserializerConfiguration::deserializer).forEach(deserializer -> reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{deserializer}).reason(this.getClass().getName()).build()));
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ArcHeartbeatFactory.class, ArcPostProcessorFactory.class, DebeziumEngine.BuilderFactory.class, ConvertingAsyncEngineBuilderFactory.class, SaslClientAuthenticator.class, JsonConverter.class, DefaultTransactionMetadataFactory.class, SchemaTopicNamingStrategy.class, OffsetCommitPolicy.class, BaseSourceTask.class, SinkNotificationChannel.class, LogNotificationChannel.class, JmxNotificationChannel.class, SnapshotLock.class, NoLockingSupport.class, AlwaysSnapshotter.class, InitialSnapshotter.class, InitialOnlySnapshotter.class, NoDataSnapshotter.class, RecoverySnapshotter.class, WhenNeededSnapshotter.class, NeverSnapshotter.class, ExtractNewRecordState.class, TopicNameMatches.class, ConfigurationBasedSnapshotter.class, SourceSignalChannel.class, KafkaSignalChannel.class, FileSignalChannel.class, JmxSignalChannel.class, InProcessSignalChannel.class, StandardActionProvider.class, OffsetCommitPolicy.class, SourceTask.class, QuarkusNotificationChannel.class, OffsetCommitPolicy.PeriodicCommitOffsetPolicy.class}).reason(this.getClass().getName()).build());
    }

    private List<Type> extractClassToDeserialize(CombinedIndexBuildItem indexBuildItem) {
        return indexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple(ObjectMapperDeserializer.class)).stream().flatMap(clazz -> clazz.superClassType().asParameterizedType().arguments().stream()).toList();
    }

    private List<String> extractDeserializers(DebeziumEngineConfiguration debeziumEngineConfiguration) {
        return debeziumEngineConfiguration.capturing().values().stream().filter(capturing -> capturing.destination().isPresent() && capturing.deserializer().isPresent()).map(DebeziumEngineConfiguration.Capturing::deserializer).flatMap(Optional::stream).toList();
    }

    @BuildStep
    public void generateInvokers(List<DebeziumMediatorBuildItem> mediatorBuildItems, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, BuildProducer<DebeziumGeneratedInvokerBuildItem> debeziumGeneratedInvokerBuildItemBuildProducer, BuildProducer<DebeziumGeneratedCustomConverterBuildItem> debeziumGeneratedCustomConverterBuildItemBuildProducer, BuildProducer<DebeziumGeneratedPostProcessorBuildItem> debeziumGeneratedPostProcessorBuildItemmBuildProducer) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClassBuildItemBuildProducer, true);
        MultipleCapturingInvokerGenerators capturingInvokerGenerator = new MultipleCapturingInvokerGenerators(new CapturingEventGenerator((ClassOutput)classOutput), new CapturingObjectInvokerGenerator((ClassOutput)classOutput));
        PostProcessorGenerator postProcessorGenerator = new PostProcessorGenerator((ClassOutput)classOutput);
        CustomConverterGenerator customConverterGenerator = new CustomConverterGenerator((ClassOutput)classOutput);
        Map<Type, DebeziumMediatorBuildItem> fieldFilterStrategyByClassName = mediatorBuildItems.stream().filter(item -> item.getDotName().equals((Object)DebeziumDotNames.FIELD_FILTER_STRATEGY)).collect(Collectors.toMap(item -> item.getBean().getProviderType(), item -> item));
        mediatorBuildItems.forEach(item -> {
            if (item.getDotName().equals((Object)DebeziumDotNames.CAPTURING)) {
                GeneratedClassMetaData metadata = capturingInvokerGenerator.generate(item.getMethodInfo(), item.getBean());
                debeziumGeneratedInvokerBuildItemBuildProducer.produce((BuildItem)new DebeziumGeneratedInvokerBuildItem(metadata.generatedClassName(), metadata.mediator(), metadata.getShortIdentifier(), metadata.clazz()));
                reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{metadata.generatedClassName()}).build());
            }
            if (item.getDotName().equals((Object)DebeziumDotNames.POST_PROCESSING)) {
                GeneratedClassMetaData metaData = postProcessorGenerator.generate(item.getMethodInfo(), item.getBean());
                debeziumGeneratedPostProcessorBuildItemmBuildProducer.produce((BuildItem)new DebeziumGeneratedPostProcessorBuildItem(metaData.generatedClassName(), metaData.mediator(), metaData.getShortIdentifier()));
                reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{metaData.generatedClassName()}).build());
            }
            if (item.getDotName().equals((Object)DebeziumDotNames.CUSTOM_CONVERTER)) {
                BeanInfo filter = Optional.ofNullable(item.getMethodInfo().annotation(DebeziumDotNames.CUSTOM_CONVERTER).value("filter")).map(AnnotationValue::asClass).map(fieldFilterStrategyByClassName::get).map(DebeziumMediatorBuildItem::getBean).orElse(null);
                GeneratedConverterClassMetaData metaData = customConverterGenerator.generate(item.getMethodInfo(), item.getBean(), filter);
                debeziumGeneratedCustomConverterBuildItemBuildProducer.produce((BuildItem)new DebeziumGeneratedCustomConverterBuildItem(metaData.generatedClassName(), metaData.binder(), metaData.getShortIdentifier(), metaData.filter()));
                reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{metaData.generatedClassName()}).build());
            }
        });
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void injectInvokers(DynamicCapturingInvokerSupplier dynamicCapturingInvokerSupplier, RecorderContext recorderContext, List<DebeziumGeneratedInvokerBuildItem> debeziumGeneratedInvokerBuildItems, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        debeziumGeneratedInvokerBuildItems.forEach(item -> syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((Class)item.getClazz()).setRuntimeInit().scope(ApplicationScoped.class)).unremovable()).supplier(dynamicCapturingInvokerSupplier.createInvoker(recorderContext.classProxy(item.getMediator().getImplClazz().name().toString()), recorderContext.classProxy(item.getGeneratedClassName()))).named("invoker" + String.valueOf(item.getMediator().getImplClazz().name()) + item.getId())).done()));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void injectPostProcessors(RecorderContext recorderContext, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, DynamicPostProcessingSupplier dynamicPostProcessingSupplier, List<DebeziumGeneratedPostProcessorBuildItem> debeziumGeneratedPostProcessorBuildItems) {
        debeziumGeneratedPostProcessorBuildItems.forEach(item -> syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(PostProcessor.class).setRuntimeInit().scope(ApplicationScoped.class)).unremovable()).supplier(dynamicPostProcessingSupplier.createPostProcessor(recorderContext.classProxy(item.getMediator().getImplClazz().name().toString()), recorderContext.classProxy(item.getGeneratedClassName()))).named("postProcessing" + String.valueOf(item.getMediator().getImplClazz().name()) + item.getId())).done()));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void injectCustomConverters(RecorderContext recorderContext, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, DynamicCustomConverterSupplier dynamicCustomConverterSupplier, List<DebeziumGeneratedCustomConverterBuildItem> debeziumGeneratedCustomConverterBuildItems) {
        debeziumGeneratedCustomConverterBuildItems.forEach(item -> syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(QuarkusCustomConverter.class).setRuntimeInit().scope(ApplicationScoped.class)).unremovable()).supplier(dynamicCustomConverterSupplier.createQuarkusCustomConverter(recorderContext.classProxy(item.getBinder().getImplClazz().name().toString()), item.getFilter() != null ? recorderContext.classProxy(item.getFilter().getImplClazz().name().toString()) : null, recorderContext.classProxy(item.getGeneratedClassName()))).named(DynamicCustomConverterSupplier.BASE_NAME + String.valueOf(item.getBinder().getImplClazz().name()) + item.getId())).done()));
    }

    @BuildStep
    public void extractMediators(BuildProducer<DebeziumMediatorBuildItem> mediatorBuildItemBuildProducer, BeanDiscoveryFinishedBuildItem beanDiscoveryFinished) {
        DebeziumDotNames dbz = new DebeziumDotNames();
        beanDiscoveryFinished.beanStream().classBeans().stream().filter(arg_0 -> ((DebeziumDotNames)dbz).filter(arg_0)).flatMap(beanInfo -> beanInfo.getTarget().map(target -> target.asClass().methods()).stream().flatMap(Collection::stream).filter(arg_0 -> ((DebeziumDotNames)dbz).filter(arg_0)).map(methodInfo -> new DebeziumMediatorBuildItem(beanInfo, methodInfo, dbz.get(methodInfo)))).forEach(arg_0 -> mediatorBuildItemBuildProducer.produce(arg_0));
        beanDiscoveryFinished.beanStream().classBeans().filter(info -> info.getImplClazz().interfaceNames().contains(DebeziumDotNames.FIELD_FILTER_STRATEGY)).stream().map(info -> new DebeziumMediatorBuildItem(info, null, DebeziumDotNames.FIELD_FILTER_STRATEGY)).forEach(arg_0 -> mediatorBuildItemBuildProducer.produce(arg_0));
    }

    @BuildStep
    public List<UnremovableBeanBuildItem> removalExclusion() {
        return DebeziumDotNames.dotNames.stream().map(dotName -> new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(dotName))).toList();
    }

    @BuildStep
    public UnremovableBeanBuildItem avoidRemovalIfNotReferenced() {
        return UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{FieldFilterStrategy.class});
    }
}

